/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class PBEffectGenerateByStructure
extends PBEffectNormal {
    public Structure[] structures;

    public PBEffectGenerateByStructure() {
    }

    public PBEffectGenerateByStructure(int maxTicksAlive) {
        super(maxTicksAlive);
        this.structures = new Structure[0];
    }

    @Override
    public void doEffect(World world, EntityPandorasBox entity, Random random, float newRatio, float prevRatio) {
        for (Structure structure : this.structures) {
            float newStructureRatio = this.getStructureRatio(newRatio, structure);
            float prevStructureRatio = this.getStructureRatio(prevRatio, structure);
            int baseX = MathHelper.func_76128_c((double)entity.field_70165_t);
            int baseY = MathHelper.func_76128_c((double)entity.field_70163_u);
            int baseZ = MathHelper.func_76128_c((double)entity.field_70161_v);
            if (!(newStructureRatio > prevStructureRatio)) continue;
            this.generateStructure(world, entity, random, structure, baseX, baseY, baseZ, newStructureRatio, prevStructureRatio);
        }
    }

    private float getStructureRatio(float ratio, Structure structure) {
        return MathHelper.func_76131_a((float)((ratio - structure.structureStart) / structure.structureLength), (float)0.0f, (float)1.0f);
    }

    public abstract void generateStructure(World var1, EntityPandorasBox var2, Random var3, Structure var4, int var5, int var6, int var7, float var8, float var9);

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList structureTagList = new NBTTagList();
        for (Structure structure : this.structures) {
            NBTTagCompound structureCompound = new NBTTagCompound();
            structure.writeToNBT(structureCompound);
            structureTagList.func_74742_a((NBTBase)structureCompound);
        }
        compound.func_74782_a("structures", (NBTBase)structureTagList);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList structureTagList = compound.func_150295_c("structures", 10);
        this.structures = new Structure[structureTagList.func_74745_c()];
        for (int i = 0; i < this.structures.length; ++i) {
            this.structures[i] = this.createStructure(structureTagList.func_150305_b(i));
        }
    }

    public abstract Structure createStructure();

    public Structure createStructure(NBTTagCompound compound) {
        Structure structure = this.createStructure();
        structure.readFromNBT(compound);
        return structure;
    }

    public static void applyRandomProperties(Structure structure, double range, Random random) {
        structure.structureLength = random.nextFloat() * 0.8f + 0.1f;
        structure.structureStart = random.nextFloat() * (1.0f - structure.structureLength);
        structure.x = MathHelper.func_76128_c((double)((random.nextDouble() - random.nextDouble()) * range));
        structure.y = MathHelper.func_76128_c((double)((random.nextDouble() - random.nextDouble()) * range));
        structure.z = MathHelper.func_76128_c((double)((random.nextDouble() - random.nextDouble()) * range));
        structure.unifiedSeed = PandorasBoxHelper.getRandomUnifiedSeed(random);
    }

    public static class Structure {
        public float structureStart;
        public float structureLength;
        public int x;
        public int y;
        public int z;
        public int unifiedSeed;

        public Structure() {
        }

        public Structure(float structureStart, float structureLength, int x, int y, int z, int unifiedSeed) {
            this.structureStart = structureStart;
            this.structureLength = structureLength;
            this.x = x;
            this.y = y;
            this.z = z;
            this.unifiedSeed = unifiedSeed;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74776_a("structureStart", this.structureStart);
            compound.func_74776_a("structureLength", this.structureLength);
            compound.func_74768_a("x", this.x);
            compound.func_74768_a("y", this.y);
            compound.func_74768_a("z", this.z);
            compound.func_74768_a("unifiedSeed", this.unifiedSeed);
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.structureStart = compound.func_74760_g("structureStart");
            this.structureLength = compound.func_74760_g("structureLength");
            this.x = compound.func_74762_e("x");
            this.y = compound.func_74762_e("y");
            this.z = compound.func_74762_e("z");
            this.unifiedSeed = compound.func_74762_e("unifiedSeed");
        }
    }
}

