/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PBEffectMulti
extends PBEffect {
    public PBEffect[] effects;
    public int[] delays;

    public PBEffectMulti() {
    }

    public PBEffectMulti(PBEffect[] effects, int[] delays) {
        this.effects = effects;
        this.delays = delays;
    }

    @Override
    public void doTick(EntityPandorasBox entity, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            this.effects[i].doTick(entity, effectTicks);
        }
    }

    @Override
    public boolean isDone(EntityPandorasBox entity, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            if (this.effects[i].isDone(entity, effectTicks)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.effects.length; ++i) {
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74768_a("delay", this.delays[i]);
            cmp.func_74778_a("pbEffectID", this.effects[i].getEffectID());
            NBTTagCompound effectCmp = new NBTTagCompound();
            this.effects[i].writeToNBT(effectCmp);
            cmp.func_74782_a("pbEffectCompound", (NBTBase)effectCmp);
            list.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("effects", (NBTBase)list);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("effects", 10);
        this.effects = new PBEffect[list.func_74745_c()];
        this.delays = new int[this.effects.length];
        for (int i = 0; i < this.effects.length; ++i) {
            NBTTagCompound cmp = list.func_150305_b(i);
            this.delays[i] = cmp.func_74762_e("delay");
            this.effects[i] = PBEffectRegistry.loadEffect(cmp.func_74779_i("pbEffectID"), cmp.func_74775_l("pbEffectCompound"));
        }
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(EntityPandorasBox entity) {
        for (PBEffect effect : this.effects) {
            if (effect.canGenerateMoreEffectsAfterwards(entity)) continue;
            return false;
        }
        return true;
    }
}

