/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class PBEffectRangeBased
extends PBEffectNormal {
    public double range;
    public int passes;

    public PBEffectRangeBased() {
    }

    public PBEffectRangeBased(int maxTicksAlive, double range, int passes) {
        super(maxTicksAlive);
        this.range = range;
        this.passes = passes;
    }

    @Override
    public void doEffect(World world, EntityPandorasBox entity, Random random, float newRatio, float prevRatio) {
        for (int i = 0; i < this.passes; ++i) {
            double prevRange = this.getRange(prevRatio, i);
            double newRange = this.getRange(newRatio, i);
            this.generateInRange(world, entity, random, newRange, prevRange, i);
        }
    }

    private double getRange(float ratio, int pass) {
        double fullRange = this.range + (double)(this.passes - 1) * 5.0;
        double tempRange = (double)ratio * fullRange - (double)pass * 5.0;
        return MathHelper.func_151237_a((double)tempRange, (double)0.0, (double)this.range);
    }

    public abstract void generateInRange(World var1, EntityPandorasBox var2, Random var3, double var4, double var6, int var8);

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74780_a("range", this.range);
        compound.func_74768_a("passes", this.passes);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.range = compound.func_74769_h("range");
        this.passes = compound.func_74762_e("passes");
    }
}

