/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class PBEffectSpawnEntities
extends PBEffectNormal {
    public int number;
    public boolean spawnFromBox;
    public double range;
    public double shiftY;
    public double throwStrengthSideMin;
    public double throwStrengthSideMax;
    public double throwStrengthYMin;
    public double throwStrengthYMax;

    protected PBEffectSpawnEntities() {
    }

    public PBEffectSpawnEntities(int time, int number) {
        super(time);
        this.number = number;
    }

    public void setDoesNotSpawnFromBox(double range, double shiftY) {
        this.spawnFromBox = false;
        this.range = range;
        this.shiftY = shiftY;
    }

    public void setDoesSpawnFromBox(double throwStrengthSideMin, double throwStrengthSideMax, double throwStrengthYMin, double throwStrengthYMax) {
        this.spawnFromBox = true;
        this.throwStrengthSideMin = throwStrengthSideMin;
        this.throwStrengthSideMax = throwStrengthSideMax;
        this.throwStrengthYMin = throwStrengthYMin;
        this.throwStrengthYMax = throwStrengthYMax;
    }

    @Override
    public void doEffect(World world, EntityPandorasBox entity, Random random, float newRatio, float prevRatio) {
        if (!world.field_72995_K) {
            int prev = this.getSpawnNumber(prevRatio);
            int toSpawn = this.getSpawnNumber(newRatio) - prev;
            for (int i = 0; i < toSpawn; ++i) {
                double eZ;
                double eY;
                double eX;
                if (this.spawnFromBox) {
                    eX = entity.field_70165_t;
                    eY = entity.field_70163_u;
                    eZ = entity.field_70161_v;
                } else {
                    eX = entity.field_70165_t + (random.nextDouble() - random.nextDouble()) * this.range;
                    eY = entity.field_70163_u + (random.nextDouble() - random.nextDouble()) * 3.0 + this.shiftY;
                    eZ = entity.field_70161_v + (random.nextDouble() - random.nextDouble()) * this.range;
                }
                Entity newEntity = this.createEntity(world, entity, random, prev + i, eX, eY, eZ);
                if (newEntity == null) continue;
                if (this.spawnFromBox) {
                    float dirSide = random.nextFloat() * 2.0f * 3.1415925f;
                    double throwStrengthSide = this.throwStrengthSideMin + random.nextDouble() * (this.throwStrengthSideMax - this.throwStrengthSideMin);
                    newEntity.field_70159_w = (double)MathHelper.func_76126_a((float)dirSide) * throwStrengthSide;
                    newEntity.field_70181_x = this.throwStrengthYMin + random.nextDouble() * (this.throwStrengthYMax - this.throwStrengthYMin);
                    newEntity.field_70179_y = (double)MathHelper.func_76134_b((float)dirSide) * throwStrengthSide;
                }
                world.func_72838_d(newEntity);
            }
        }
    }

    private int getSpawnNumber(float ratio) {
        return MathHelper.func_76141_d((float)(ratio * (float)this.number));
    }

    public abstract Entity createEntity(World var1, EntityPandorasBox var2, Random var3, int var4, double var5, double var7, double var9);

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("number", this.number);
        compound.func_74757_a("spawnFromBox", this.spawnFromBox);
        compound.func_74780_a("range", this.range);
        compound.func_74780_a("shiftY", this.shiftY);
        compound.func_74780_a("throwStrengthSideMin", this.throwStrengthSideMin);
        compound.func_74780_a("throwStrengthSideMax", this.throwStrengthSideMax);
        compound.func_74780_a("throwStrengthYMin", this.throwStrengthYMin);
        compound.func_74780_a("throwStrengthYMax", this.throwStrengthYMax);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.number = compound.func_74762_e("number");
        this.spawnFromBox = compound.func_74767_n("spawnFromBox");
        this.range = compound.func_74769_h("range");
        this.shiftY = compound.func_74769_h("shiftY");
        this.throwStrengthSideMin = compound.func_74769_h("throwStrengthSideMin");
        this.throwStrengthSideMax = compound.func_74769_h("throwStrengthSideMax");
        this.throwStrengthYMin = compound.func_74769_h("throwStrengthYMin");
        this.throwStrengthYMax = compound.func_74769_h("throwStrengthYMax");
    }
}

