/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PBConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    private static final String CONFIG_PREFIX = "gui.pandorasbox.config.";
    public static boolean allowLootTableInjection;
    public static double boxLongevity;
    public static double boxIntensity;
    public static int maxEffectsPerBox;
    public static double goodEffectChance;

    public static void loadConfig() {
        allowLootTableInjection = (Boolean)PBConfig.COMMON.allowLootTableInjection.get();
        boxLongevity = (Double)PBConfig.COMMON.boxLongevity.get();
        boxIntensity = (Double)PBConfig.COMMON.boxIntensity.get();
        maxEffectsPerBox = (Integer)PBConfig.COMMON.maxEffectsPerBox.get();
        goodEffectChance = (Double)PBConfig.COMMON.goodEffectChance.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue allowLootTableInjection;
        public final ForgeConfigSpec.DoubleValue boxLongevity;
        public final ForgeConfigSpec.DoubleValue boxIntensity;
        public final ForgeConfigSpec.IntValue maxEffectsPerBox;
        public final ForgeConfigSpec.DoubleValue goodEffectChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            this.allowLootTableInjection = builder.comment("Whether Pandora's Box will inject loot into loot tables").translation("gui.pandorasbox.config.allowLootTableInjection").worldRestart().define("allowLootTableInjection", true);
            this.boxLongevity = builder.comment("How long a box will last (with continuous effects). Represented by 'chance to continue'.").translation("gui.pandorasbox.config.boxLongevity").worldRestart().defineInRange("boxLongevity", 0.2, 0.0, 1.0);
            this.boxIntensity = builder.comment("How many effects a box will have at once. Represented by 'chance for another effect'. Ex.: 0 for 'Always exactly one effect', 3 for '3 times the default chance'.").translation("gui.pandorasbox.config.boxIntensity").worldRestart().defineInRange("boxIntensity", 1.0, 0.0, 10.0);
            this.maxEffectsPerBox = builder.comment("The value up to which the intensity can increase. Keep in mind high values can cause strong lag.").translation("gui.pandorasbox.config.maxEffectsPerBox").worldRestart().defineInRange("maxEffectsPerBox", 3, 1, 100);
            this.goodEffectChance = builder.comment("The chance for each effect to be 'positive'.").translation("gui.pandorasbox.config.goodEffectChance").worldRestart().defineInRange("goodEffectChance", 0.49, 0.0, 10.0);
            builder.build();
        }
    }
}

