/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.init.Registry;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedEntity;
import ivorius.pandorasbox.weighted.WeightedPotion;
import ivorius.pandorasbox.weighted.WeightedSelector;
import ivorius.pandorasbox.weighted.WeightedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class PandorasBoxHelper {
    public static List<WeightedEntity> mobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> creatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterCreatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterMobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> tameableCreatures = new ArrayList<WeightedEntity>();
    public static List<RandomizedItemStack> blocksAndItems = new ArrayList<RandomizedItemStack>();
    public static Multimap<Block, Property<?>> randomizableBlockProperties = HashMultimap.create();
    public static List<WeightedBlock> blocks = new ArrayList<WeightedBlock>();
    public static List<RandomizedItemStack> items = new ArrayList<RandomizedItemStack>();
    public static List<WeightedSet> equipmentSets = new ArrayList<WeightedSet>();
    public static Hashtable<Item, Hashtable<Integer, ItemStack>> equipmentForLevels = new Hashtable();
    public static List<WeightedPotion> buffs = new ArrayList<WeightedPotion>();
    public static List<WeightedPotion> debuffs = new ArrayList<WeightedPotion>();
    public static List<RandomizedItemStack> enchantableArmorList = new ArrayList<RandomizedItemStack>();
    public static List<RandomizedItemStack> enchantableToolList = new ArrayList<RandomizedItemStack>();
    public static List<WeightedBlock> heavyBlocks = new ArrayList<WeightedBlock>();

    public static void addEntities(List<WeightedEntity> list, double weight, int minNumber, int maxNumber, String ... entities) {
        for (String s : entities) {
            list.add(new WeightedEntity(weight, s, minNumber, maxNumber));
        }
    }

    public static void addBlocks(double weight, Block ... blocks) {
        for (Block block : blocks) {
            PandorasBoxHelper.blocks.add(new WeightedBlock(weight, block));
            Item item = block.func_199767_j();
            if (item == null) continue;
            PandorasBoxHelper.addItem(new RandomizedItemStack(item, 1, item.getItemStackLimit(new ItemStack((IItemProvider)item)), weight));
        }
    }

    public static void addBlocks(double weight, List<Block> blocks) {
        for (Block block : blocks) {
            PandorasBoxHelper.blocks.add(new WeightedBlock(weight, block));
            Item item = block.func_199767_j();
            if (item == null) continue;
            PandorasBoxHelper.addItem(new RandomizedItemStack(item, 1, item.getItemStackLimit(new ItemStack((IItemProvider)item)), weight));
        }
    }

    public static void addBlocks(List<WeightedBlock> list, double weight, Block ... blocks) {
        for (Block block : blocks) {
            list.add(new WeightedBlock(weight, block));
        }
    }

    public static void addItem(RandomizedItemStack RandomizedItemStack2) {
        items.add(RandomizedItemStack2);
        blocksAndItems.add(RandomizedItemStack2);
    }

    public static void addItems(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, 1, item.getItemStackLimit(new ItemStack((IItemProvider)item)), weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, 1, itemStack.func_77973_b().getItemStackLimit(itemStack), weight));
        }
    }

    public static void addItemsMinMax(double weight, int min, int max, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, min, max, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, min, max, weight));
        }
    }

    public static void addEquipmentSet(double weight, Object ... items) {
        ItemStack[] set = new ItemStack[items.length];
        for (int i = 0; i < set.length; ++i) {
            ItemStack itemStack;
            if (items[i] instanceof Item) {
                Item item = (Item)items[i];
                set[i] = new ItemStack((IItemProvider)item);
                continue;
            }
            if (!(items[i] instanceof ItemStack)) continue;
            set[i] = itemStack = (ItemStack)items[i];
        }
        equipmentSets.add(new WeightedSet(weight, set));
    }

    public static void addPotions(List<WeightedPotion> list, double weight, int minStrength, int maxStrength, int minDuration, int maxDuration, Effect ... potions) {
        for (Effect effect : potions) {
            list.add(new WeightedPotion(weight, effect, minStrength, maxStrength, minDuration, maxDuration));
        }
    }

    public static void addEnchantableArmor(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableArmorList.add(new RandomizedItemStack(item, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableArmorList.add(new RandomizedItemStack(itemStack, 1, 1, weight));
        }
    }

    public static void addEnchantableTools(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableToolList.add(new RandomizedItemStack(item, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableToolList.add(new RandomizedItemStack(itemStack, 1, 1, weight));
        }
    }

    public static void addEquipmentForLevel(Item base, int level, ItemStack stack) {
        if (!equipmentForLevels.containsKey(base)) {
            equipmentForLevels.put(base, new Hashtable());
        }
        equipmentForLevels.get(base).put(level, stack);
    }

    public static void addEquipmentLevelsInOrder(Item base, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object instanceof Item) {
                PandorasBoxHelper.addEquipmentForLevel(base, i, new ItemStack((IItemProvider)((Item)items[i])));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            PandorasBoxHelper.addEquipmentForLevel(base, i, (ItemStack)items[i]);
        }
    }

    public static void addAllRandomizableBlockProperties(List<Block> blocks) {
        for (Block block : blocks) {
            randomizableBlockProperties.putAll((Object)block, (Iterable)block.func_176223_P().func_235904_r_());
        }
    }

    public static void addRandomizableBlockProperty(Block[] blocks, Property ... properties) {
        for (Block block : blocks) {
            for (Property property : properties) {
                randomizableBlockProperties.put((Object)block, (Object)property);
            }
        }
    }

    public static void addRandomizableBlockProperty(Block block, Property ... properties) {
        for (Property property : properties) {
            randomizableBlockProperties.put((Object)block, (Object)property);
        }
    }

    public static void initialize() {
        mobs = new ArrayList<WeightedEntity>();
        creatures = new ArrayList<WeightedEntity>();
        waterCreatures = new ArrayList<WeightedEntity>();
        waterMobs = new ArrayList<WeightedEntity>();
        tameableCreatures = new ArrayList<WeightedEntity>();
        blocks = new ArrayList<WeightedBlock>();
        randomizableBlockProperties = HashMultimap.create();
        blocksAndItems = new ArrayList<RandomizedItemStack>();
        items = new ArrayList<RandomizedItemStack>();
        equipmentSets = new ArrayList<WeightedSet>();
        equipmentForLevels = new Hashtable();
        buffs = new ArrayList<WeightedPotion>();
        debuffs = new ArrayList<WeightedPotion>();
        enchantableArmorList = new ArrayList<RandomizedItemStack>();
        enchantableToolList = new ArrayList<RandomizedItemStack>();
        heavyBlocks = new ArrayList<WeightedBlock>();
        PandorasBoxHelper.addEntities(mobs, 10.0, 3, 10, "zombie", "drowned");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 8, "spider");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 5, "skeleton");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 5, "pbspecial_skeletonWither");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 8, "creeper");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "slime");
        PandorasBoxHelper.addEntities(mobs, 4.0, 1, 4, "ghast");
        PandorasBoxHelper.addEntities(mobs, 4.0, 1, 4, "phantom");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "zombified_piglin");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "hoglin");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "zoglin");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 6, "enderman");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 4, "cave_spider");
        PandorasBoxHelper.addEntities(mobs, 5.0, 10, 20, "silverfish");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 5, "blaze");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 6, "magma_cube");
        PandorasBoxHelper.addEntities(mobs, 1.0, 1, 1, "wither");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 4, "witch");
        PandorasBoxHelper.addEntities(mobs, 6.0, 10, 20, "endermite");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 6, "pbspecial_angryWolf");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 5, "pbspecial_superchargedCreeper");
        PandorasBoxHelper.addEntities(creatures, 10.0, 3, 10, "pig", "sheep", "cow", "chicken");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "wolf");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "panda");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "fox");
        PandorasBoxHelper.addEntities(creatures, 5.0, 4, 10, "bat");
        PandorasBoxHelper.addEntities(creatures, 7.0, 6, 20, "rabbit");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "mooshroom");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "snow_golem");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 5, "horse");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 6, "ocelot", "cat");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "villager");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "piglin");
        PandorasBoxHelper.addEntities(creatures, 3.0, 2, 4, "iron_golem");
        PandorasBoxHelper.addEntities(waterCreatures, 6.0, 3, 10, "squid", "cod", "salmon", "pufferfish", "turtle", "tropical_fish");
        PandorasBoxHelper.addEntities(waterMobs, 6.0, 3, 10, "guardian");
        PandorasBoxHelper.addEntities(waterMobs, 5.0, 1, 1, "pbspecial_elderGuardian");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_wolfTamed");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_ocelotTamed");
        ArrayListExtensions<Block> planks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> glass = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> randomizable = new ArrayListExtensions<Block>();
        ArrayListExtensions<Item> misc = new ArrayListExtensions<Item>();
        ArrayListExtensions records = new ArrayListExtensions();
        ArrayListExtensions dyes = new ArrayListExtensions();
        glass.addAll(Blocks.field_150365_q, Blocks.field_150369_x, Blocks.field_150450_ax, Blocks.field_196766_fg, Blocks.field_150359_w);
        planks.addAll(Blocks.field_150348_b, Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_196650_c, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150354_m, Blocks.field_196611_F);
        randomizable.addAll(Blocks.field_150348_b, Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_196650_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_150390_bg, Blocks.field_150371_ca, Blocks.field_150370_cb, Blocks.field_196581_bI, Blocks.field_222440_ld, Blocks.field_150322_A, Blocks.field_150372_bz, Blocks.field_180395_cM, Blocks.field_180396_cN, Blocks.field_150448_aq, Blocks.field_150460_al, Blocks.field_150423_aK, Blocks.field_196628_cT, Blocks.field_150433_aE, Blocks.field_196604_cC, Blocks.field_150486_ae, Blocks.field_150477_bB, Blocks.field_150447_bR, Blocks.field_150360_v);
        planks.addAll(new Collection[]{PandorasBox.planks, PandorasBox.logs, PandorasBox.leaves, PandorasBox.wool, PandorasBox.slabs, PandorasBox.bricks, PandorasBox.stained_terracotta});
        randomizable.addAll(new Collection[]{PandorasBox.planks, PandorasBox.logs, PandorasBox.leaves, PandorasBox.wool, PandorasBox.slabs, PandorasBox.bricks, PandorasBox.stained_terracotta, PandorasBox.stained_glass, PandorasBox.saplings, PandorasBox.pots});
        glass.addAll(Blocks.field_150425_aM, Blocks.field_235336_cN_);
        glass.addAll(PandorasBox.stained_glass);
        misc.addAll(Items.field_151129_at, Items.field_151117_aB, Items.field_151131_as, Items.field_151033_d, Items.field_151159_an, Items.field_222087_nH, Items.field_151143_au, Items.field_222089_ms);
        for (Item item : ForgeRegistries.ITEMS) {
            if (ItemTags.field_202902_o.func_230235_a_((Object)item) || ItemTags.field_219771_F.func_230235_a_((Object)item)) {
                misc.add(item);
            }
            if (ItemTags.field_219774_K.func_230235_a_((Object)item)) {
                records.add(item);
            }
            if (!(item instanceof DyeItem)) continue;
            dyes.add(item);
        }
        PandorasBoxHelper.addBlocks(40.0, planks);
        PandorasBoxHelper.addBlocks(15.0, Blocks.field_180397_cI, Blocks.field_150371_ca);
        PandorasBoxHelper.addBlocks(10.0, Blocks.field_150347_e, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_196653_dH, Blocks.field_196584_bK, Blocks.field_150377_bs, Blocks.field_196806_hJ, Blocks.field_150405_ch);
        PandorasBoxHelper.addBlocks(10.0, Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150423_aK, Blocks.field_150435_aG, Blocks.field_150391_bh);
        PandorasBoxHelper.addBlocks(8.0, glass);
        PandorasBoxHelper.addBlocks(0.2, Blocks.field_150484_ah, Blocks.field_150475_bE, Blocks.field_150340_R);
        PandorasBoxHelper.addBlocks(0.3, Blocks.field_150339_S);
        PandorasBoxHelper.addBlocks(0.5, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150352_o);
        PandorasBoxHelper.addBlocks(1.0, Blocks.field_150366_p);
        PandorasBoxHelper.addBlocks(2.0, Blocks.field_150335_W, Blocks.field_150426_aN, Blocks.field_150402_ci, Blocks.field_150368_y, Blocks.field_150451_bX, Blocks.field_180399_cE, Blocks.field_150360_v);
        PandorasBoxHelper.addBlocks(5.0, Blocks.field_150380_bt, Blocks.field_150379_bu, Blocks.field_180398_cJ, Blocks.field_150433_aE, Blocks.field_150342_X, Blocks.field_196628_cT, Blocks.field_150407_cf, Blocks.field_150343_Z, Blocks.field_150440_ba);
        PandorasBoxHelper.addItems(10.0, Items.field_151044_h, Items.field_151016_H, Items.field_151015_O, Items.field_151141_av, Items.field_151137_ax, Items.field_151103_aS, Items.field_221794_dg, Items.field_151119_aD, Items.field_151122_aG, Items.field_151074_bl, Items.field_151174_bG, Items.field_151133_ar, Items.field_151055_y, Items.field_151007_F, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N, Items.field_151126_ay, Items.field_151102_aT, Items.field_151112_aM, Items.field_151156_bN, Items.field_151075_bm, Items.field_151145_ak, Items.field_151110_aK, Items.field_151118_aC, Items.field_151121_aF, Items.field_221657_bQ);
        PandorasBoxHelper.addItems(10.0, Registry.PBI.get());
        PandorasBoxHelper.addItems(10.0, Items.field_151076_bf, Items.field_151077_bg, Items.field_151082_bd, Items.field_151158_bO, Items.field_151083_be, Items.field_151009_A, Items.field_151078_bh, Items.field_151172_bF, Items.field_151147_al, Items.field_151157_am, Items.field_151034_e, Items.field_222070_lD, Items.field_151025_P, Items.field_151106_aX, Items.field_196086_aW, Items.field_196102_ba, Items.field_196087_aX, Items.field_196104_bb, Items.field_196089_aZ, Items.field_179561_bm, Items.field_179557_bn, Items.field_179558_bo, Items.field_179556_br, Items.field_179555_bs, Items.field_179560_bq, Items.field_179559_bp);
        PandorasBoxHelper.addItems(8.0, misc);
        PandorasBoxHelper.addItems(8.0, Items.field_151057_cb);
        PandorasBoxHelper.addItems(6.0, Items.field_151042_j, Items.field_151114_aO, Items.field_151065_br, Items.field_151072_bj, Items.field_151113_aN, Items.field_151073_bk, Items.field_151061_bv, Items.field_151060_bw, Items.field_151070_bp, Items.field_151071_bq, Items.field_151064_bs, Items.field_151150_bK);
        PandorasBoxHelper.addItems(4.0, Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151041_m, Items.field_151039_o, Items.field_151038_n, Items.field_151053_p, Items.field_151017_I);
        PandorasBoxHelper.addItems(4.0, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151010_B, Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M);
        PandorasBoxHelper.addItems(4.0, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151040_l, Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K);
        PandorasBoxHelper.addItems(3.0, Items.field_151138_bX, Items.field_151136_bY);
        PandorasBoxHelper.addItems(2.0, Items.field_151125_bZ);
        PandorasBoxHelper.addItemsMinMax(2.0, 1, 1, Items.field_221749_dK, Items.field_221844_ef, Items.field_222088_mr, Items.field_221656_ap, Items.field_221735_dD, Items.field_221778_cy, Items.field_221824_dv);
        PandorasBoxHelper.addItemsMinMax(5.0, 1, 1, Items.field_221675_bZ, Items.field_222100_pG);
        PandorasBoxHelper.addItems(2.0, Items.field_151045_i, Items.field_151166_bC, Items.field_151043_k, Items.field_151153_ao, Items.field_151079_bi, Items.field_179563_cD, Items.field_179562_cC);
        PandorasBoxHelper.addItems(2.0, Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_151048_u, Items.field_151046_w, Items.field_151047_v, Items.field_151056_x, Items.field_151012_L);
        PandorasBoxHelper.addItems(2.0, records);
        for (Item dye : dyes) {
            PandorasBoxHelper.addItems(10.0, new ItemStack((IItemProvider)dye, 1));
        }
        PandorasBoxHelper.addEquipmentSet(10.0, Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151041_m, Items.field_151039_o, Items.field_151038_n, Items.field_151053_p, Items.field_151017_I);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151040_l, Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K);
        PandorasBoxHelper.addEquipmentSet(4.0, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151010_B, Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M);
        PandorasBoxHelper.addEquipmentSet(2.0, Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_151048_u, Items.field_151046_w, Items.field_151047_v, Items.field_151056_x, Items.field_151012_L);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151031_f, new ItemStack((IItemProvider)Items.field_151032_g, 64), Items.field_151028_Y, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151036_c, new ItemStack((IItemProvider)Items.field_151034_e, 8));
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151028_Y, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T, Items.field_151046_w, Items.field_151037_a, Items.field_151036_c, Items.field_151052_q, new ItemStack((IItemProvider)Items.field_151025_P, 8), new ItemStack((IItemProvider)Items.field_221657_bQ, 32));
        PandorasBoxHelper.addEquipmentSet(8.0, Items.field_151024_Q, Items.field_151019_K, new ItemStack((IItemProvider)Items.field_151014_N, 32), new ItemStack((IItemProvider)Items.field_151080_bb, 4), new ItemStack((IItemProvider)Items.field_151081_bc, 4), new ItemStack((IItemProvider)Items.field_222083_lx, 8), new ItemStack((IItemProvider)Items.field_221582_j, 32), Items.field_151131_as, Items.field_151131_as);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.field_151028_Y, Items.field_151056_x, new ItemStack((IItemProvider)Items.field_151082_bd, 16));
        for (Block block : PandorasBox.wool) {
            Random random = new Random();
            if (!(random.nextDouble() > 0.8)) continue;
            PandorasBoxHelper.addEquipmentSet(6.0, new ItemStack((IItemProvider)Items.field_151137_ax, 64), new ItemStack((IItemProvider)block, 16), new ItemStack((IItemProvider)block, 16), new ItemStack((IItemProvider)block, 16), new ItemStack((IItemProvider)Blocks.field_150451_bX, 8), new ItemStack((IItemProvider)Blocks.field_150429_aA, 8));
        }
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151041_m, Items.field_151041_m, Items.field_151010_B, Items.field_151052_q, Items.field_151040_l, Items.field_151048_u);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151053_p, Items.field_151053_p, Items.field_151006_E, Items.field_151049_t, Items.field_151036_c, Items.field_151056_x);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151039_o, Items.field_151039_o, Items.field_151005_D, Items.field_151050_s, Items.field_151035_b, Items.field_151046_w);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151038_n, Items.field_151038_n, Items.field_151011_C, Items.field_151051_r, Items.field_151037_a, Items.field_151047_v);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.field_151017_I, Items.field_151017_I, Items.field_151013_M, Items.field_151018_J, Items.field_151019_K, Items.field_151012_L);
        PandorasBoxHelper.addPotions(buffs, 10.0, 0, 3, 1200, 12000, Effects.field_76428_l, Effects.field_76424_c, Effects.field_76420_g, Effects.field_76430_j, Effects.field_76429_m, Effects.field_76427_o, Effects.field_76426_n, Effects.field_76439_r, Effects.field_76441_p, Effects.field_76444_x);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 3, 1200, 12000, Effects.field_76440_q, Effects.field_76431_k, Effects.field_76419_f, Effects.field_76437_t, Effects.field_76438_s);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 2, 600, 1200, Effects.field_82731_v);
        PandorasBoxHelper.addEnchantableArmor(10.0, Items.field_151028_Y, Items.field_151169_ag, Items.field_151161_ac, Items.field_151030_Z, Items.field_151171_ah, Items.field_151163_ad, Items.field_151165_aa, Items.field_151149_ai, Items.field_151173_ae, Items.field_151167_ab, Items.field_151151_aj, Items.field_151175_af);
        PandorasBoxHelper.addEnchantableTools(10.0, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u, Items.field_151037_a, Items.field_151011_C, Items.field_151047_v, Items.field_151035_b, Items.field_151005_D, Items.field_151046_w, Items.field_151036_c, Items.field_151006_E, Items.field_151056_x, Items.field_151031_f);
        PandorasBoxHelper.addBlocks(heavyBlocks, 10.0, Blocks.field_150467_bQ);
        PandorasBoxHelper.addAllRandomizableBlockProperties(randomizable);
    }

    public static int getRandomUnifiedSeed(Random random) {
        return Math.abs(random.nextInt());
    }

    private static <T> T randomElement(Collection<T> collection, Random random) {
        int num = random.nextInt(collection.size());
        int i = 0;
        for (T t : collection) {
            if (i++ != num) continue;
            return t;
        }
        throw new InternalError();
    }

    public static BlockState getRandomBlockState(Random rand, Block block, int unified) {
        BlockState state = block.func_176223_P();
        Collection randomizableProperties = randomizableBlockProperties.get((Object)block);
        if (randomizableProperties != null) {
            if (unified >= 0) {
                rand = new Random(unified ^ rand.nextInt(256));
            }
            for (Property property : randomizableProperties) {
                state = (BlockState)state.func_206870_a(property, (Comparable)PandorasBoxHelper.randomElement(property.func_177700_c(), rand));
            }
        }
        return state;
    }

    public static Block[] getRandomBlockList(Random rand, Collection<WeightedBlock> selection) {
        int number;
        for (number = 1; number < 10 && rand.nextFloat() < 0.7f; ++number) {
        }
        int[] weights = new int[number];
        for (int i = 0; i < number; ++i) {
            weights[i] = 1;
            while (weights[i] < 10 && rand.nextFloat() < 0.7f) {
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        int total = 0;
        for (int i : weights) {
            total += i;
        }
        Block[] blocks = new Block[total];
        int blockIndex = 0;
        for (int i = 0; i < number; ++i) {
            Block block = WeightedSelector.selectItem((Random)rand, selection).block;
            for (int j = 0; j < weights[i]; ++j) {
                blocks[blockIndex] = block;
                ++blockIndex;
            }
        }
        return blocks;
    }

    public static Block getRandomBlock(Random rand, Collection<WeightedBlock> randomBlockList) {
        if (randomBlockList != null && randomBlockList.size() > 0) {
            return WeightedSelector.selectItem((Random)rand, randomBlockList).block;
        }
        return WeightedSelector.selectItem((Random)rand, PandorasBoxHelper.blocks).block;
    }

    public static WeightedEntity[] getRandomEntityList(Random rand, Collection<WeightedEntity> selection) {
        WeightedEntity[] entities = new WeightedEntity[rand.nextInt(5) + 1];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = PandorasBoxHelper.getRandomEntityFromList(rand, selection);
        }
        return entities;
    }

    public static WeightedEntity getRandomEntityFromList(Random rand, Collection<WeightedEntity> entityList) {
        return WeightedSelector.selectItem(rand, entityList);
    }

    public static ItemStack getRandomWeaponItemForLevel(Random random, int level) {
        Set<Item> itemSet = equipmentForLevels.keySet();
        Item[] itemArray = itemSet.toArray(new Item[itemSet.size()]);
        return PandorasBoxHelper.getWeaponItemForLevel(itemArray[random.nextInt(itemArray.length)], level);
    }

    public static ItemStack getWeaponItemForLevel(Item baseItem, int level) {
        Hashtable<Integer, ItemStack> levels = equipmentForLevels.get(baseItem);
        if (levels != null) {
            while (level > 0) {
                if (levels.containsKey(level)) {
                    return levels.get(level);
                }
                --level;
            }
        }
        return null;
    }
}

