/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Objects;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PandorasBoxRenderer<T extends PandorasBoxEntity>
extends EntityRenderer<T> {
    public PandorasBoxModel model;
    public ResourceLocation texture = new ResourceLocation("pandorasbox", "textures/entity/pandoras_box.png");

    public PandorasBoxRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.model = new PandorasBoxModel();
        this.field_76989_e = 0.6f;
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLightIn) {
        PBEffectRenderer renderer;
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, renderTypeBuffer, packedLightIn);
        matrixStack.func_227860_a_();
        this.model.PBE = entity;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-entityYaw));
        PBEffect effect = ((PandorasBoxEntity)entity).getBoxEffect();
        boolean visible = !entity.func_82150_aj();
        IVertexBuilder builder = renderTypeBuffer.getBuffer(Objects.requireNonNull(this.model.func_228282_a_(this.getTextureLocation(entity))));
        if (!effect.isDone((PandorasBoxEntity)entity, ((PandorasBoxEntity)entity).getEffectTicksExisted()) && ((PandorasBoxEntity)entity).getDeathTicks() < 0 && (renderer = PBEffectRenderingRegistry.rendererForEffect(effect)) != null) {
            renderer.renderBox((PandorasBoxEntity)entity, effect, partialTicks, matrixStack, builder);
        }
        if (visible) {
            float boxScale = ((PandorasBoxEntity)entity).getCurrentScale();
            if (boxScale < 1.0f) {
                matrixStack.func_227862_a_(boxScale, boxScale, boxScale);
            }
            matrixStack.func_227861_a_(0.0, 1.5, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            ArrowEntity emptyEntity = new ArrowEntity(((PandorasBoxEntity)entity).field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            emptyEntity.field_70125_A = ((PandorasBoxEntity)entity).getRatioBoxOpen(partialTicks) * 120.0f / 180.0f * 3.1415925f;
            int i = OverlayTexture.field_229196_a_;
            this.model.setupAnim(emptyEntity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f);
            this.model.func_225598_a_(matrixStack, builder, packedLightIn, i, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(T var1) {
        return this.texture;
    }
}

