/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import java.util.Random;
import net.minecraft.world.World;

public class PBECMulti
implements PBEffectCreator {
    public PBEffectCreator[] effects;
    public int[] delays;

    public PBECMulti(PBEffectCreator[] effects, int[] delays) {
        this.effects = effects;
        this.delays = delays;
    }

    public PBECMulti(Object ... effectsAndDelays) {
        this.effects = new PBEffectCreator[effectsAndDelays.length / 2];
        this.delays = new int[this.effects.length];
        for (int i = 0; i < this.effects.length; ++i) {
            this.effects[i] = (PBEffectCreator)effectsAndDelays[i * 2];
            this.delays[i] = (Integer)effectsAndDelays[i * 2 + 1];
        }
    }

    @Override
    public PBEffect constructEffect(World world, double x, double y, double z, Random random) {
        PBEffect[] createdEffects = new PBEffect[this.effects.length];
        for (int i = 0; i < this.effects.length; ++i) {
            createdEffects[i] = this.effects[i].constructEffect(world, x, y, z, random);
        }
        return new PBEffectMulti(createdEffects, (int[])this.delays.clone());
    }

    @Override
    public float chanceForMoreEffects(World world, double x, double y, double z, Random random) {
        float min = 999.0f;
        for (PBEffectCreator effect : this.effects) {
            min = Math.min(effect.chanceForMoreEffects(world, x, y, z, random), min);
        }
        return min;
    }
}

