/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectGenReplace;
import ivorius.pandorasbox.random.DValue;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.weighted.WeightedBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PBECReplace
implements PBEffectCreator {
    public DValue range;
    public Block[] srcBlocks;
    public Collection<WeightedBlock> destBlocks;
    public ZValue takeRandomNearbyBlocks;

    public PBECReplace(DValue range, Block[] srcBlocks, Collection<WeightedBlock> destBlocks, ZValue takeRandomNearbyBlocks) {
        this.range = range;
        this.srcBlocks = srcBlocks;
        this.destBlocks = destBlocks;
        this.takeRandomNearbyBlocks = takeRandomNearbyBlocks;
    }

    @Override
    public PBEffect constructEffect(World world, double x, double y, double z, Random random) {
        double range = this.range.getValue(random);
        int time = MathHelper.func_76128_c((double)((random.nextDouble() * 7.0 + 3.0) * range));
        int baseX = MathHelper.func_76128_c((double)x);
        int baseY = MathHelper.func_76128_c((double)y);
        int baseZ = MathHelper.func_76128_c((double)z);
        boolean takeRandomNearbyBlocks = this.takeRandomNearbyBlocks.getValue(random);
        Block[] srcSelection = new Block[]{};
        if (takeRandomNearbyBlocks) {
            ArrayList<WeightedBlock> nearbyBlocks = new ArrayList<WeightedBlock>();
            for (int xP = -5; xP <= 5; ++xP) {
                for (int yP = -5; yP <= 5; ++yP) {
                    for (int zP = -5; zP <= 5; ++zP) {
                        BlockState block = world.func_180495_p(new BlockPos(baseX + xP, baseY + yP, baseZ + zP));
                        if (block.func_185904_a() == Material.field_151579_a) continue;
                        nearbyBlocks.add(new WeightedBlock(100.0, block.func_177230_c()));
                    }
                }
            }
            if (nearbyBlocks.size() > 0) {
                srcSelection = PandorasBoxHelper.getRandomBlockList(random, nearbyBlocks);
            }
        } else {
            srcSelection = (Block[])this.srcBlocks.clone();
        }
        Block[] destSelection = PandorasBoxHelper.getRandomBlockList(random, this.destBlocks);
        PBEffectGenReplace genReplace = new PBEffectGenReplace(time, range, PandorasBoxHelper.getRandomUnifiedSeed(random), destSelection, srcSelection);
        return genReplace;
    }

    @Override
    public float chanceForMoreEffects(World world, double x, double y, double z, Random random) {
        return 0.1f;
    }
}

