/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.PBEffectSpawnEntityIDList;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class PBEffect {
    public String getEffectID() {
        return PBEffectRegistry.getEffectID(this);
    }

    public static boolean setBlockToAirSafe(World world, BlockPos pos) {
        boolean safeDest = world.func_180495_p(pos).isAir((IBlockReader)world, pos) || world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f;
        return safeDest && world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public static boolean setBlockSafe(World world, BlockPos pos, BlockState state) {
        boolean safeDest = world.func_180495_p(pos).isAir((IBlockReader)world, pos) || world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f;
        boolean safeSrc = state.isAir((IBlockReader)world, pos) || state.func_185887_b((IBlockReader)world, pos) >= 0.0f;
        return safeDest && safeSrc && world.func_175656_a(pos, state);
    }

    public static boolean setBlockUnsafeSrc(World world, BlockPos pos, BlockState state) {
        boolean safeDest = world.func_180495_p(pos).isAir((IBlockReader)world, pos) || world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f;
        return safeDest && world.func_175656_a(pos, state);
    }

    public static boolean setBlockVarying(World world, BlockPos pos, Block block, int unified) {
        return PBEffect.setBlockSafe(world, pos, PandorasBoxHelper.getRandomBlockState(world.field_73012_v, block, unified));
    }

    public static boolean setBlockVaryingUnsafeSrc(World world, BlockPos pos, Block block, int unified) {
        return PBEffect.setBlockUnsafeSrc(world, pos, PandorasBoxHelper.getRandomBlockState(world.field_73012_v, block, unified));
    }

    public static PlayerEntity getRandomNearbyPlayer(World world, PandorasBoxEntity box) {
        List players = world.func_217357_a(PlayerEntity.class, box.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
        return (PlayerEntity)players.get(box.getRandom().nextInt(players.size()));
    }

    public static PlayerEntity getPlayer(World world, PandorasBoxEntity box) {
        return PBEffect.getRandomNearbyPlayer(world, box);
    }

    public static boolean isBlockAnyOf(Block block, Block ... blocks) {
        for (Block block1 : blocks) {
            if (block != block1) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockAnyOf(Block block, List<Block> blocks) {
        for (Block block1 : blocks) {
            if (block != block1) continue;
            return true;
        }
        return false;
    }

    public static Entity lazilySpawnEntity(World world, PandorasBoxEntity box, Random random, String entityID, float chance, BlockPos pos) {
        Entity entity;
        if (random.nextFloat() < chance && !world.func_201670_d() && (entity = PBEffectSpawnEntityIDList.createEntity(world, box, random, entityID, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5)) != null) {
            return entity;
        }
        return null;
    }

    public static Entity lazilySpawnFlyingEntity(World world, PandorasBoxEntity box, Random random, String entityID, float chance, BlockPos pos) {
        Entity entity = PBEffect.lazilySpawnEntity(world, box, random, entityID, chance, pos);
        if (entity != null) {
            world.func_217376_c(entity);
        }
        return entity;
    }

    public static boolean canSpawnEntity(World world, BlockState block, BlockPos pos, Entity entity) {
        if (entity == null) {
            return false;
        }
        if (world.func_201670_d()) {
            return false;
        }
        if (block.func_200016_a((IBlockReader)world, pos) > 0) {
            return false;
        }
        if (world.func_217400_a(pos.func_177977_b(), entity) && !world.func_201670_d()) {
            world.func_217376_c(entity);
            return true;
        }
        return false;
    }

    public boolean canSpawnFlyingEntity(World world, BlockState block, BlockPos pos) {
        if (world.func_201670_d()) {
            return false;
        }
        return block.func_200016_a((IBlockReader)world, pos) <= 0 && world.func_180495_p(pos.func_177977_b()).func_200016_a((IBlockReader)world, pos.func_177977_b()) <= 0 && world.func_180495_p(pos.func_177979_c(2)).func_200016_a((IBlockReader)world, pos.func_177979_c(2)) <= 0;
    }

    public void addPotionEffectDuration(LivingEntity entity, Potion potionEffect) {
        for (EffectInstance effectInstance : potionEffect.func_185170_a()) {
            EffectInstance prevEffect;
            if (!entity.func_70687_e(effectInstance)) continue;
            boolean addNewEffect = true;
            if (entity.func_70644_a(effectInstance.func_188419_a()) && (prevEffect = entity.func_70660_b(effectInstance.func_188419_a())).func_76458_c() == effectInstance.func_76458_c()) {
                int duration = prevEffect.func_76459_b() + effectInstance.func_76459_b();
                EffectInstance combined = new EffectInstance(effectInstance.func_188419_a(), duration, effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e());
                entity.func_195064_c(combined);
            }
            entity.func_195064_c(effectInstance);
        }
    }

    public abstract void doTick(PandorasBoxEntity var1, Vec3d var2, int var3);

    public abstract boolean isDone(PandorasBoxEntity var1, int var2);

    public abstract void writeToNBT(CompoundNBT var1);

    public abstract void readFromNBT(CompoundNBT var1);

    public abstract boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity var1);
}

