/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.init.Registry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PBEffectDuplicateBox
extends PBEffectNormal {
    public static final int MODE_BOX_IN_BOX = 0;
    public int spawnMode;

    public PBEffectDuplicateBox() {
    }

    public static int timeNeededForSpawnMode(int mode) {
        if (mode == 0) {
            return 60;
        }
        return 0;
    }

    public PBEffectDuplicateBox(int spawnMode) {
        super(PBEffectDuplicateBox.timeNeededForSpawnMode(spawnMode));
        this.spawnMode = spawnMode;
    }

    @Override
    public void setUpEffect(World world, PandorasBoxEntity box, Vec3d effectCenter, Random random) {
        if (world instanceof ServerWorld) {
            PBEffect effect = PBECRegistry.createRandomEffect(world, random, box.func_226277_ct_(), box.func_226278_cu_(), box.func_226281_cx_(), true);
            PandorasBoxEntity newBox = (PandorasBoxEntity)((EntityType)Registry.Box.get()).func_200721_a(world);
            assert (newBox != null);
            newBox.setBoxEffect(effect);
            newBox.setTimeBoxWaiting(40);
            newBox.func_70012_b(box.func_226277_ct_(), box.func_226278_cu_(), box.func_226281_cx_(), box.field_70177_z, box.field_70125_A);
            if (this.spawnMode == 0) {
                newBox.beginFloatingUp();
                newBox.beginScalingIn();
                world.func_217376_c((Entity)newBox);
            }
        }
    }

    @Override
    public void doEffect(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, float prevRatio, float newRatio) {
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("spawnMode", this.spawnMode);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.spawnMode = compound.func_74762_e("spawnMode");
    }
}

