/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PBEffectEntitiesBuff
extends PBEffectEntityBased {
    public EffectInstance[] effects;

    public PBEffectEntitiesBuff() {
    }

    public PBEffectEntitiesBuff(int maxTicksAlive, double range, EffectInstance[] effects) {
        super(maxTicksAlive, range);
        this.effects = effects;
    }

    @Override
    public void affectEntity(World world, PandorasBoxEntity box, Random random, LivingEntity entity, double newRatio, double prevRatio, double strength) {
        for (EffectInstance effect : this.effects) {
            int prevDuration = MathHelper.func_76128_c((double)(prevRatio * strength * (double)effect.func_76459_b()));
            int newDuration = MathHelper.func_76128_c((double)(newRatio * strength * (double)effect.func_76459_b()));
            int duration = newDuration - prevDuration;
            if (duration <= 0) continue;
            EffectInstance effectInstance = new EffectInstance(effect.func_188419_a(), duration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e());
            Potion curEffect = new Potion(new EffectInstance[]{effectInstance});
            this.addPotionEffectDuration(entity, curEffect);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        PBNBTHelper.writeNBTPotions("potions", this.effects, compound);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.effects = PBNBTHelper.readNBTPotions("potions", compound);
    }
}

