/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class PBEffectEntitiesTeleport
extends PBEffectEntityBased {
    private double teleportRange;
    private int teleports;

    public PBEffectEntitiesTeleport() {
    }

    public PBEffectEntitiesTeleport(int maxTicksAlive, double range, double teleportRange, int teleports) {
        super(maxTicksAlive, range);
        this.teleportRange = teleportRange;
        this.teleports = teleports;
    }

    @Override
    public void affectEntity(World world, PandorasBoxEntity box, Random random, LivingEntity entity, double newRatio, double prevRatio, double strength) {
        if (world instanceof ServerWorld) {
            Random entityRandom = new Random(entity.func_145782_y());
            for (int i = 0; i < this.teleports; ++i) {
                double expectedTeleport = entityRandom.nextDouble();
                if (!(newRatio >= expectedTeleport) || !(prevRatio < expectedTeleport)) continue;
                double newX = entity.func_226277_ct_() + (random.nextDouble() - random.nextDouble()) * this.teleportRange;
                double newZ = entity.func_226281_cx_() + (random.nextDouble() - random.nextDouble()) * this.teleportRange;
                double newY = (double)world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(newX, 0.0, newZ)).func_177956_o() + 0.2;
                float newYaw = random.nextFloat() * 360.0f;
                entity.func_70634_a(newX, newY, newZ);
                if (!(entity instanceof ServerPlayerEntity)) continue;
                ((ServerPlayerEntity)entity).field_71135_a.func_147364_a(newX, newY, newZ, newYaw, entity.field_70125_A);
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74780_a("teleportRange", this.teleportRange);
        compound.func_74768_a("teleports", this.teleports);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.teleportRange = compound.func_74769_h("teleportRange");
        this.teleports = compound.func_74762_e("teleports");
    }
}

