/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PBEffectEntitiesThrowItems
extends PBEffectEntityBased {
    public double chancePerItem;
    public double itemDeletionChance;
    public ItemStack[] smuggledInItems;

    public PBEffectEntitiesThrowItems() {
    }

    public PBEffectEntitiesThrowItems(int maxTicksAlive, double range, double chancePerItem, double itemDeletionChance, ItemStack[] smuggledInItems) {
        super(maxTicksAlive, range);
        this.chancePerItem = chancePerItem;
        this.itemDeletionChance = itemDeletionChance;
        this.smuggledInItems = smuggledInItems;
    }

    @Override
    public void affectEntity(World world, PandorasBoxEntity box, Random random, LivingEntity entity, double newRatio, double prevRatio, double strength) {
        if (world instanceof ServerWorld && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Random itemRandom = new Random(entity.func_145782_y());
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack;
                double expectedThrow = itemRandom.nextDouble();
                if (!(newRatio >= expectedThrow) || !(prevRatio < expectedThrow) || (stack = player.field_71071_by.func_70301_a(i)) == null || !(random.nextDouble() < this.chancePerItem)) continue;
                if (random.nextDouble() >= this.itemDeletionChance) {
                    player.func_71019_a(stack, false);
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            for (ItemStack smuggledInItem : this.smuggledInItems) {
                double expectedThrow = itemRandom.nextDouble();
                if (!(newRatio >= expectedThrow) || !(prevRatio < expectedThrow)) continue;
                player.func_71019_a(smuggledInItem, false);
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74780_a("chancePerItem", this.chancePerItem);
        compound.func_74780_a("itemDeletionChance", this.itemDeletionChance);
        PBNBTHelper.writeNBTStacks("smuggledInItems", this.smuggledInItems, compound);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.chancePerItem = compound.func_74769_h("chancePerItem");
        this.itemDeletionChance = compound.func_74769_h("itemDeletionChance");
        this.smuggledInItems = PBNBTHelper.readNBTStacks("smuggledInItems", compound);
    }
}

