/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class PBEffectEntityBased
extends PBEffectNormal {
    public double range;

    public PBEffectEntityBased() {
    }

    public PBEffectEntityBased(int maxTicksAlive, double range) {
        super(maxTicksAlive);
        this.range = range;
    }

    @Override
    public void doEffect(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, float prevRatio, float newRatio) {
        AxisAlignedBB bb = new AxisAlignedBB(effectCenter.field_72450_a - this.range, effectCenter.field_72448_b - this.range, effectCenter.field_72449_c - this.range, effectCenter.field_72450_a + this.range, effectCenter.field_72448_b + this.range, effectCenter.field_72449_c + this.range);
        List entities = world.func_217357_a(LivingEntity.class, bb);
        for (LivingEntity entityLivingBase : entities) {
            double dist = entityLivingBase.func_70032_d((Entity)entity);
            double strength = (this.range - dist) / this.range;
            if (!(strength > 0.0)) continue;
            this.affectEntity(world, entity, random, entityLivingBase, newRatio, prevRatio, strength);
        }
    }

    public abstract void affectEntity(World var1, PandorasBoxEntity var2, Random var3, LivingEntity var4, double var5, double var7, double var9);

    @Override
    public void writeToNBT(CompoundNBT compound) {
        compound.func_74780_a("range", this.range);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        this.range = compound.func_74769_h("range");
    }
}

