/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.server.ServerWorld;

public class PBEffectGenConvertToNether
extends PBEffectGenerate {
    private String biome;
    private int timesFeatureAMade = 0;
    private int timesFeatureBMade = 0;

    public PBEffectGenConvertToNether() {
    }

    public PBEffectGenConvertToNether(int time, double range, int unifiedSeed, String biome) {
        super(time, range, 2, unifiedSeed);
        this.biome = biome;
    }

    @Override
    public void generateOnBlock(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, int pass, BlockPos pos, double range) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            switch (this.biome) {
                case "wastes": {
                    this.createWastes(serverWorld, entity, random, pass, pos);
                    break;
                }
                case "soul_sand_valley": {
                    this.createSoul(serverWorld, entity, random, pass, pos);
                    break;
                }
                case "crimson": {
                    this.createCrimson(serverWorld, entity, random, pass, pos);
                    break;
                }
                case "warped": {
                    this.createWarped(serverWorld, entity, random, pass, pos);
                    break;
                }
                case "deltas": {
                    this.createDeltas(serverWorld, entity, random, pass, pos);
                }
            }
        }
    }

    public void createWastes(ServerWorld world, PandorasBoxEntity entity, Random random, int pass, BlockPos pos) {
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.field_150433_aE, Blocks.field_196604_cC, Blocks.field_150395_bd, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_150349_c, Blocks.field_196554_aH, Blocks.field_196805_gi, Blocks.field_203198_aQ, Blocks.field_203199_aR, Blocks.field_150337_Q, Blocks.field_150338_P);
        misc.addAll(Blocks.field_196658_i, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150377_bs, Blocks.field_150391_bh);
        blocks.addAll(new Collection[]{PandorasBox.flowers, PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150347_e, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150343_Z)) {
                Optional integer = blockState.func_235903_d_((Property)FlowingFluidBlock.field_176367_b);
                Object blockState2 = Blocks.field_150353_l.func_176223_P();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, (BlockState)blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((World)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150435_aG)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196814_hQ.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150365_q)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196766_fg.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150352_o)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235334_I_.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150354_m, Blocks.field_196611_F)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150425_aM.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150424_aL.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_196650_c)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235406_np_.func_176223_P());
            } else if (world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
                if (random.nextInt(25) == 0) {
                    if (world.field_73012_v.nextFloat() < 0.99f) {
                        if (world.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_232880_av_)) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235335_bO_.func_176223_P());
                        } else if (!world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150480_ab.func_176223_P());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150426_aN.func_176223_P());
                    }
                } else if (!world.func_180495_p(pos.func_177984_a()).func_196958_f() && (double)random.nextFloat() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "piglin", 0.0011111111f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "zombified_piglin", 0.0044444446f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "magma_cube", 0.0044444446f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "hoglin", 0.0025f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((World)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((World)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
        if (random.nextDouble() < Math.pow(0.4, Math.floor((double)this.timesFeatureAMade / 4.0))) {
            boolean success;
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && blockBelowState.func_215686_e((IBlockReader)world, posBelow) && (success = Features.field_243821_aT.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos))) {
                ++this.timesFeatureAMade;
            }
        }
        if (random.nextDouble() < Math.pow(0.3, Math.floor((double)this.timesFeatureBMade / 4.0))) {
            boolean success;
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && blockBelowState.func_215686_e((IBlockReader)world, posBelow) && (success = Features.field_243822_aU.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos))) {
                ++this.timesFeatureBMade;
            }
        }
    }

    public void createSoul(ServerWorld world, PandorasBoxEntity entity, Random random, int pass, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.field_150433_aE, Blocks.field_196604_cC, Blocks.field_150395_bd, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_150349_c, Blocks.field_196554_aH, Blocks.field_196805_gi, Blocks.field_203198_aQ, Blocks.field_203199_aR, Blocks.field_150337_Q, Blocks.field_150338_P);
        misc.addAll(Blocks.field_196658_i, Blocks.field_150346_d, Blocks.field_150377_bs, Blocks.field_150391_bh);
        blocks.addAll(new Collection[]{PandorasBox.flowers, PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150347_e, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150343_Z)) {
                Optional integer = blockState.func_235903_d_((Property)FlowingFluidBlock.field_176367_b);
                BlockState blockState2 = Blocks.field_150353_l.func_176223_P();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((World)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_150435_aG)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150425_aM.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150365_q)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196766_fg.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150352_o)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235334_I_.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235336_cN_.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150348_b, Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_150322_A, Blocks.field_180395_cM)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150424_aL.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_196650_c)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235406_np_.func_176223_P());
            } else if (world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
                boolean bl;
                boolean bl2 = !PBEffectGenConvertToNether.isBlockAnyOf(world.func_180495_p(pos.func_177977_b()).func_177230_c(), Blocks.field_189880_di) ? random.nextInt(40) == 0 : (bl = random.nextInt(20) == 0);
                if (random.nextInt(25) == 0) {
                    if (world.field_73012_v.nextFloat() < 0.99f) {
                        if (world.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_232880_av_)) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235335_bO_.func_176223_P());
                        } else if (!world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150480_ab.func_176223_P());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150426_aN.func_176223_P());
                    }
                } else if (!world.func_180495_p(pos.func_177984_a()).func_196958_f() && (double)random.nextFloat() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                } else if (!world.func_180495_p(pos.func_177977_b()).isAir((IBlockReader)world, pos.func_177977_b()) && !PBEffectGenConvertToNether.isBlockAnyOf(world.func_180495_p(pos.func_177977_b()).func_177230_c(), Blocks.field_150426_aN) && bl) {
                    PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_189880_di.func_176223_P());
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "skeleton", 0.0044444446f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "zombified_piglin", 0.0044444446f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((World)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((World)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
    }

    public void createCrimson(ServerWorld world, PandorasBoxEntity entity, Random random, int pass, BlockPos pos) {
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> flowers = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.field_150433_aE, Blocks.field_196604_cC, Blocks.field_150395_bd, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_150349_c, Blocks.field_196554_aH, Blocks.field_196805_gi, Blocks.field_203198_aQ, Blocks.field_203199_aR, Blocks.field_150337_Q, Blocks.field_150338_P);
        misc.addAll(Blocks.field_196658_i, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150377_bs, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F);
        blocks.addAll(new Collection[]{PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        flowers.addAll(PandorasBox.flowers);
        blocks.removeAll(Blocks.field_235377_mq_, Blocks.field_235378_mr_, Blocks.field_235368_mh_, Blocks.field_235369_mi_);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150347_e, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150343_Z)) {
                Optional integer = blockState.func_235903_d_((Property)FlowingFluidBlock.field_176367_b);
                Object blockState2 = Blocks.field_150353_l.func_176223_P();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, (BlockState)blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((World)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150435_aG)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196814_hQ.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150365_q)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196766_fg.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150352_o)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235334_I_.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                if (random.nextDouble() < 0.2 || !world.func_180495_p(pos.func_177984_a()).isAir((IBlockReader)world, pos.func_177984_a())) {
                    PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150424_aL.func_176223_P());
                } else {
                    PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235381_mu_.func_176223_P());
                }
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, flowers)) {
                if (random.nextDouble() < 0.5) {
                    PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235343_mB_.func_176223_P());
                } else {
                    PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235382_mv_.func_176223_P());
                }
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_196650_c)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235406_np_.func_176223_P());
            } else if (world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
                if (random.nextInt(25) == 0) {
                    if (world.field_73012_v.nextFloat() < 0.99f) {
                        if (world.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_232880_av_)) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235335_bO_.func_176223_P());
                        } else if (!world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150480_ab.func_176223_P());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150426_aN.func_176223_P());
                    }
                } else if (!world.func_180495_p(pos.func_177984_a()).func_196958_f() && (double)random.nextFloat() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "piglin", 0.01f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "zombified_piglin", 0.0016f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "hoglin", 0.01f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((World)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((World)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
        if (random.nextDouble() < Math.pow(0.4, Math.floor((double)this.timesFeatureAMade / 8.0))) {
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && !blockBelowState.func_203425_a(Blocks.field_189878_dg) && blockBelowState.func_215686_e((IBlockReader)world, posBelow)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, posBelow, Blocks.field_235381_mu_.func_176223_P());
                boolean success = Features.field_243857_bC.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos);
                if (success) {
                    ++this.timesFeatureAMade;
                }
            }
        }
        if (random.nextDouble() < Math.pow(0.6, Math.floor((double)this.timesFeatureBMade / 10.0))) {
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && !blockBelowState.func_203425_a(Blocks.field_189878_dg) && blockBelowState.func_215686_e((IBlockReader)world, posBelow)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, posBelow, Blocks.field_235381_mu_.func_176223_P());
                boolean success = Features.field_243954_n.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos);
                if (success) {
                    ++this.timesFeatureBMade;
                }
            }
        }
    }

    public void createWarped(ServerWorld world, PandorasBoxEntity entity, Random random, int pass, BlockPos pos) {
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState;
        block14: {
            block12: {
                block22: {
                    block23: {
                        block24: {
                            block21: {
                                Block block;
                                block20: {
                                    ArrayListExtensions<Block> flowers;
                                    block19: {
                                        ArrayListExtensions<Block> misc;
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        ArrayListExtensions<Block> blocks;
                                                        block13: {
                                                            blockState = world.func_180495_p(pos);
                                                            block = blockState.func_177230_c();
                                                            blocks = new ArrayListExtensions<Block>();
                                                            misc = new ArrayListExtensions<Block>();
                                                            flowers = new ArrayListExtensions<Block>();
                                                            blocks.addAll(Blocks.field_150433_aE, Blocks.field_196604_cC, Blocks.field_150395_bd, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_150349_c, Blocks.field_196554_aH, Blocks.field_196805_gi, Blocks.field_203198_aQ, Blocks.field_203199_aR, Blocks.field_150337_Q, Blocks.field_150338_P);
                                                            misc.addAll(Blocks.field_196658_i, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_196656_g, Blocks.field_196650_c, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150377_bs, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F);
                                                            blocks.addAll(new Collection[]{PandorasBox.logs, PandorasBox.leaves});
                                                            misc.addAll(PandorasBox.terracotta);
                                                            flowers.addAll(PandorasBox.flowers);
                                                            blocks.removeAll(Blocks.field_235377_mq_, Blocks.field_235378_mr_, Blocks.field_235368_mh_, Blocks.field_235369_mi_);
                                                            if (pass != 0) break block12;
                                                            if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150347_e, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150343_Z)) break block13;
                                                            Optional integer = blockState.func_235903_d_((Property)FlowingFluidBlock.field_176367_b);
                                                            BlockState blockState2 = Blocks.field_150353_l.func_176223_P();
                                                            if (integer.isPresent()) {
                                                                blockState2 = (BlockState)blockState2.func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)((Integer)integer.get()));
                                                            }
                                                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, blockState2);
                                                            break block14;
                                                        }
                                                        if (!PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) break block15;
                                                        PBEffectGenConvertToNether.setBlockToAirSafe((World)world, pos);
                                                        break block14;
                                                    }
                                                    if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150435_aG)) break block16;
                                                    PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196814_hQ.func_176223_P());
                                                    break block14;
                                                }
                                                if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150365_q)) break block17;
                                                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196766_fg.func_176223_P());
                                                break block14;
                                            }
                                            if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150352_o)) break block18;
                                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235334_I_.func_176223_P());
                                            break block14;
                                        }
                                        if (!PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) break block19;
                                        if (random.nextDouble() < 0.2 || !world.func_180495_p(pos.func_177984_a()).isAir((IBlockReader)world, pos.func_177984_a())) {
                                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150424_aL.func_176223_P());
                                        } else {
                                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235372_ml_.func_176223_P());
                                        }
                                        break block14;
                                    }
                                    if (!PBEffectGenConvertToNether.isBlockAnyOf(block, flowers)) break block20;
                                    if (random.nextDouble() < 0.5) {
                                        PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235375_mo_.func_176223_P());
                                    } else {
                                        PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235373_mm_.func_176223_P());
                                    }
                                    break block14;
                                }
                                if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_196650_c)) break block21;
                                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235406_np_.func_176223_P());
                                break block14;
                            }
                            if (!world.func_180495_p(pos).isAir((IBlockReader)world, pos)) break block14;
                            if (random.nextInt(25) != 0) break block22;
                            if (!(world.field_73012_v.nextFloat() < 0.99f)) break block23;
                            if (!world.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_232880_av_)) break block24;
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235335_bO_.func_176223_P());
                            break block14;
                        }
                        if (world.func_180495_p(pos.func_177977_b()).func_196958_f()) break block14;
                        PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150480_ab.func_176223_P());
                        break block14;
                    }
                    PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150426_aN.func_176223_P());
                    break block14;
                }
                if (world.func_180495_p(pos.func_177984_a()).func_196958_f() || !((double)random.nextFloat() < 0.02)) break block14;
                this.createGlowstoneBlobs(world, pos, random);
                break block14;
            }
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "enderman", 0.0044444446f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((World)world, blockState, pos, entity1);
            }
        }
        if (random.nextDouble() < Math.pow(0.4, Math.floor((double)this.timesFeatureAMade / 8.0))) {
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && !blockBelowState.func_203425_a(Blocks.field_235374_mn_) && blockBelowState.func_215686_e((IBlockReader)world, posBelow)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, posBelow, Blocks.field_235372_ml_.func_176223_P());
                boolean success = Features.field_243859_bE.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos);
                if (success) {
                    ++this.timesFeatureAMade;
                }
            }
        }
        if (random.nextDouble() < Math.pow(0.6, Math.floor((double)this.timesFeatureBMade / 10.0))) {
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && !blockBelowState.func_203425_a(Blocks.field_235374_mn_) && blockBelowState.func_215686_e((IBlockReader)world, posBelow)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, posBelow, Blocks.field_235372_ml_.func_176223_P());
                boolean success = Features.field_243955_o.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos);
                if (success) {
                    ++this.timesFeatureBMade;
                }
            }
        }
    }

    public void createDeltas(ServerWorld world, PandorasBoxEntity entity, Random random, int pass, BlockPos pos) {
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.field_150433_aE, Blocks.field_196604_cC, Blocks.field_150395_bd, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_150349_c, Blocks.field_196554_aH, Blocks.field_196805_gi, Blocks.field_203198_aQ, Blocks.field_203199_aR, Blocks.field_150337_Q, Blocks.field_150338_P);
        misc.addAll(Blocks.field_196658_i, Blocks.field_150346_d, Blocks.field_150377_bs, Blocks.field_150391_bh);
        blocks.addAll(new Collection[]{PandorasBox.flowers, PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150347_e, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150343_Z)) {
                Optional integer = blockState.func_235903_d_((Property)FlowingFluidBlock.field_176367_b);
                BlockState blockState2 = Blocks.field_150353_l.func_176223_P();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((World)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150435_aG)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196814_hQ.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150365_q)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_196766_fg.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150352_o)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235334_I_.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235337_cO_.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_150348_b, Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_150322_A, Blocks.field_180395_cM)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150424_aL.func_176223_P());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.field_196650_c, Blocks.field_150354_m, Blocks.field_196611_F)) {
                PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235406_np_.func_176223_P());
            } else if (world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
                if (random.nextInt(25) == 0) {
                    if (world.field_73012_v.nextFloat() < 0.99f) {
                        if (world.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_232880_av_)) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_235335_bO_.func_176223_P());
                        } else if (!world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                            PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150480_ab.func_176223_P());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((World)world, pos, Blocks.field_150426_aN.func_176223_P());
                    }
                } else if (!world.func_180495_p(pos.func_177984_a()).func_196958_f() && (double)random.nextFloat() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((World)world, entity, random, "magma_cube", 0.0044444446f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((World)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((World)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((World)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
        if (random.nextDouble() < Math.pow(0.8, Math.floor((double)this.timesFeatureAMade / 4.0))) {
            boolean success;
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && blockBelowState.func_215686_e((IBlockReader)world, posBelow) && (success = Features.field_243948_h.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos))) {
                ++this.timesFeatureAMade;
            }
        }
        if (random.nextDouble() < Math.pow(0.3, Math.floor((double)this.timesFeatureBMade / 4.0))) {
            boolean success;
            posBelow = pos.func_177977_b();
            blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && blockBelowState.func_215686_e((IBlockReader)world, posBelow) && (success = Features.field_243949_i.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos))) {
                ++this.timesFeatureBMade;
            }
        }
    }

    private void createGlowstoneBlobs(ServerWorld world, BlockPos pos, Random random) {
        Features.field_243952_l.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), random, pos);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.biome = compound.func_74779_i("biome");
        this.timesFeatureAMade = compound.func_74762_e("featureACount");
        this.timesFeatureBMade = compound.func_74762_e("featureBCount");
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        if (this.biome != null) {
            compound.func_74778_a("biome", this.biome);
        }
        compound.func_74768_a("featureACount", this.timesFeatureAMade);
        compound.func_74768_a("featureBCount", this.timesFeatureBMade);
    }
}

