/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate2D;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PBEffectGenDome
extends PBEffectGenerate2D {
    public Block block;
    public Block fillBlock;

    public PBEffectGenDome() {
    }

    public PBEffectGenDome(int time, double range, int unifiedSeed, Block block, Block fillBlock) {
        super(time, range, 2, unifiedSeed);
        this.block = block;
        this.fillBlock = fillBlock;
    }

    @Override
    public void generateOnSurface(World world, PandorasBoxEntity box, Vec3d effectCenter, Random random, BlockPos pos, double dist, int pass) {
        int domeHeightY = MathHelper.func_76143_f((double)this.range);
        for (int y = -domeHeightY; y <= domeHeightY; ++y) {
            BlockPos shiftedPos = pos.func_177981_b(y);
            if (pass == 0) {
                if (!PBEffectGenDome.isSpherePart((double)shiftedPos.func_177958_n() + 0.5, (double)shiftedPos.func_177956_o() + 0.5, (double)shiftedPos.func_177952_p() + 0.5, effectCenter.field_72450_a, effectCenter.field_72448_b, effectCenter.field_72449_c, this.range - 1.5, this.range) || !world.func_180495_p(shiftedPos).func_196955_c((IWorldReader)world, shiftedPos)) continue;
                PBEffectGenDome.setBlockVarying(world, shiftedPos, this.block, this.unifiedSeed);
                continue;
            }
            if (pass != 1 || this.fillBlock == null || !PBEffectGenDome.isSpherePart((double)shiftedPos.func_177958_n() + 0.5, (double)shiftedPos.func_177956_o() + 0.5, (double)shiftedPos.func_177952_p() + 0.5, effectCenter.field_72450_a, effectCenter.field_72448_b, effectCenter.field_72449_c, 0.0, this.range - 1.5) || !world.func_180495_p(shiftedPos).func_196955_c((IWorldReader)world, shiftedPos)) continue;
            PBEffectGenDome.setBlockVarying(world, shiftedPos, this.fillBlock, this.unifiedSeed);
        }
    }

    public static boolean isSpherePart(double x, double y, double z, double centerX, double centerY, double centerZ, double distStart, double distEnd) {
        double xDist = centerX - x;
        double yDist = centerY - y;
        double zDist = centerZ - z;
        double rangeSQ = xDist * xDist + yDist * yDist + zDist * zDist;
        return rangeSQ >= distStart * distStart && rangeSQ < distEnd * distEnd;
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74778_a("block", PBNBTHelper.storeBlockString(this.block));
        if (this.fillBlock != null) {
            compound.func_74778_a("fillBlock", PBNBTHelper.storeBlockString(this.fillBlock));
        }
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.block = PBNBTHelper.getBlock(compound.func_74779_i("block"));
        this.fillBlock = PBNBTHelper.getBlock(compound.func_74779_i("fillBlock"));
    }
}

