/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate2D;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PBEffectGenHeightNoise
extends PBEffectGenerate2D {
    public int minShift;
    public int maxShift;
    public int minTowerSize;
    public int maxTowerSize;
    public int blockSize;

    public PBEffectGenHeightNoise() {
    }

    public PBEffectGenHeightNoise(int time, double range, int unifiedSeed, int minShift, int maxShift, int minTowerSize, int maxTowerSize, int blockSize) {
        super(time, range, 1, unifiedSeed);
        this.minShift = minShift;
        this.maxShift = maxShift;
        this.minTowerSize = minTowerSize;
        this.maxTowerSize = maxTowerSize;
        this.blockSize = blockSize;
    }

    @Override
    public void generateOnSurface(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, BlockPos pos, double range, int pass) {
        if (world instanceof ServerWorld) {
            int randomX = pos.func_177958_n() - pos.func_177958_n() % this.blockSize;
            int randomZ = pos.func_177952_p() - pos.func_177952_p() % this.blockSize;
            Random usedRandom = new Random(new Random(randomX).nextLong() ^ new Random(randomZ).nextLong());
            int shift = this.minShift + usedRandom.nextInt(this.maxShift - this.minShift + 1);
            int towerSize = this.minTowerSize + usedRandom.nextInt(this.maxTowerSize - this.minTowerSize + 1);
            int towerMinY = pos.func_177956_o() - towerSize / 2;
            int minEffectY = towerMinY + Math.min(0, shift);
            int maxEffectY = towerMinY + towerSize + Math.max(0, shift);
            List entityList = world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - 2.0, (double)(minEffectY - 4), (double)pos.func_177952_p() - 3.0, (double)pos.func_177958_n() + 4.0, (double)(maxEffectY + 4), (double)pos.func_177952_p() + 4.0));
            if (entityList.size() == 0) {
                int y;
                BlockState[] states = new BlockState[towerSize];
                for (y = 0; y < towerSize; ++y) {
                    states[y] = world.func_180495_p(pos.func_177981_b(towerMinY));
                }
                for (y = 0; y < towerSize; ++y) {
                    PBEffectGenHeightNoise.setBlockSafe(world, pos.func_177981_b(towerMinY), states[y]);
                }
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("minShift", this.minShift);
        compound.func_74768_a("maxShift", this.maxShift);
        compound.func_74768_a("minTowerSize", this.minTowerSize);
        compound.func_74768_a("maxTowerSize", this.maxTowerSize);
        compound.func_74768_a("blockSize", this.blockSize);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.minShift = compound.func_74762_e("minShift");
        this.maxShift = compound.func_74762_e("maxShift");
        this.minTowerSize = compound.func_74762_e("minTowerSize");
        this.maxTowerSize = compound.func_74762_e("maxTowerSize");
        this.blockSize = compound.func_74762_e("blockSize");
    }
}

