/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.BlockPositions;
import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PBEffectGenLavaCages
extends PBEffectGenerate {
    public Block lavaBlock;
    public Block fillBlock;
    public Block cageBlock;
    public Block floorBlock;
    public Integer heightOffset = null;
    public Integer wallDist = null;

    public PBEffectGenLavaCages() {
    }

    public PBEffectGenLavaCages(int time, double range, int unifiedSeed, Block lavaBlock, Block cageBlock, Block fillBlock, Block floorBlock) {
        super(time, range, 1, unifiedSeed);
        this.lavaBlock = lavaBlock;
        this.cageBlock = cageBlock;
        this.fillBlock = fillBlock;
        this.floorBlock = floorBlock;
    }

    @Override
    public void generateOnBlock(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, int pass, BlockPos pos, double range) {
        List outerList;
        if (this.heightOffset == null) {
            this.heightOffset = random.nextInt(10) + 2;
        }
        if (this.wallDist == null) {
            this.wallDist = random.nextInt(5) + 2;
        }
        if (!world.func_201670_d() && !world.func_217400_a(pos, (Entity)entity) && (outerList = world.func_217357_a(PlayerEntity.class, BlockPositions.expandToAABB(pos, 3.5, 3.5, 3.5))).size() > 0) {
            for (PlayerEntity player : outerList) {
                int playerY = player.func_233580_cy_().func_177956_o();
                int playerX = player.func_233580_cy_().func_177958_n();
                int playerZ = player.func_233580_cy_().func_177952_p();
                int floor = playerY - 1;
                int ceil = playerY + this.heightOffset;
                this.createFloorOrCeil(world, playerX, floor, playerZ, this.wallDist);
                this.createFloorOrCeil(world, playerX, ceil, playerZ, this.wallDist);
                this.createWalls(world, playerX, playerY, ceil, playerZ, this.wallDist);
                this.fill(world, playerX, playerY, ceil, playerZ, this.wallDist);
            }
        }
    }

    public void createFloorOrCeil(World world, int originX, int y, int originZ, int offset) {
        for (int x = originX - offset; x <= originX + offset; ++x) {
            for (int z = originZ - offset; z <= originZ + offset; ++z) {
                PBEffectGenLavaCages.setBlockVaryingUnsafeSrc(world, new BlockPos(x, y, z), this.floorBlock, this.unifiedSeed);
            }
        }
    }

    public void createWalls(World world, int originX, int originY, int ceilheight, int originZ, int offset) {
        for (int x = originX - offset; x <= originX + offset; ++x) {
            for (int y = originY; y < ceilheight; ++y) {
                for (int z = originZ - offset; z <= originZ + offset; ++z) {
                    if (x != originX - offset && x != originX + offset && z != originZ - offset && z != originZ + offset) continue;
                    PBEffectGenLavaCages.setBlockVarying(world, new BlockPos(x, y, z), this.cageBlock, this.unifiedSeed);
                }
            }
        }
    }

    public void fill(World world, int originX, int originY, int ceilheight, int originZ, int offset) {
        boolean fill = this.fillBlock != null;
        for (int x = originX - --offset; x <= originX + offset; ++x) {
            for (int y = originY; y < ceilheight - 1; ++y) {
                for (int z = originZ - offset; z <= originZ + offset; ++z) {
                    PBEffectGenLavaCages.setBlockVarying(world, new BlockPos(x, y, z), fill ? this.fillBlock : this.lavaBlock, this.unifiedSeed);
                }
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        if (this.lavaBlock != null) {
            compound.func_74778_a("lavaBlock", PBNBTHelper.storeBlockString(this.lavaBlock));
        }
        if (this.fillBlock != null) {
            compound.func_74778_a("fillBlock", PBNBTHelper.storeBlockString(this.fillBlock));
        }
        compound.func_74778_a("cageBlock", PBNBTHelper.storeBlockString(this.cageBlock));
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.lavaBlock = PBNBTHelper.getBlock(compound.func_74779_i("lavaBlock"));
        this.fillBlock = PBNBTHelper.getBlock(compound.func_74779_i("fillBlock"));
        this.cageBlock = PBNBTHelper.getBlock(compound.func_74779_i("cageBlock"));
    }
}

