/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenStructure;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.math.IvMathHelper;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.impl.SetBlockCommand;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PBEffectGenPool
extends PBEffectGenStructure {
    public Block block;
    public Block platformBlock;

    public PBEffectGenPool() {
    }

    public PBEffectGenPool(int time, int maxX, int maxZ, int maxY, int startY, int unifiedSeed, Block block, Block platformBlock) {
        super(time, maxX, maxZ, maxY, startY, unifiedSeed, false);
        this.block = block;
        this.platformBlock = platformBlock;
    }

    @Override
    public void buildStructure(World world, PandorasBoxEntity entity, BlockPos currentPos, Random random, float prevRatio, float newRatio, int length, int width, int height, int originY, int originX, int originZ) {
        if (this.platformBlock == null) {
            this.platformBlock = Blocks.field_150371_ca;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        if (currentPos.func_177956_o() == originY) {
            PBEffectGenPool.setBlockSafe((World)serverWorld, currentPos, this.platformBlock.func_176223_P());
        } else if (IvMathHelper.compareOffsets(currentPos.func_177958_n(), originX, length) || IvMathHelper.compareOffsets(currentPos.func_177952_p(), originZ, width)) {
            PBEffectGenPool.setBlockSafe((World)serverWorld, currentPos, this.platformBlock.func_176223_P());
        } else if (currentPos.func_177956_o() < originY + height) {
            PBEffectGenPool.setBlockSafe((World)serverWorld, currentPos, this.block.func_176223_P());
        } else {
            PBEffectGenPool.setBlockToAirSafe(world, currentPos);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74778_a("block", PBNBTHelper.storeBlockString(this.block));
        if (this.platformBlock != null) {
            compound.func_74778_a("platformBlock", PBNBTHelper.storeBlockString(this.platformBlock));
        }
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.block = PBNBTHelper.getBlock(compound.func_74779_i("block"));
        this.platformBlock = PBNBTHelper.getBlock(compound.func_74779_i("platformBlock"));
    }

    static enum Mode {
        REPLACE((p_198450_0_, p_198450_1_, p_198450_2_, p_198450_3_) -> p_198450_2_);

        public final SetBlockCommand.IFilter filter;

        private Mode(SetBlockCommand.IFilter p_i47985_3_) {
            this.filter = p_i47985_3_;
        }
    }
}

