/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PBEffectGenReplace
extends PBEffectGenerate {
    public Block[] blocks;
    public Block[] blocksToReplace;

    public PBEffectGenReplace() {
    }

    public PBEffectGenReplace(int time, double range, int unifiedSeed, Block[] blocks, Block[] blocksToReplace) {
        super(time, range, 1, unifiedSeed);
        this.blocks = blocks;
        this.blocksToReplace = blocksToReplace;
    }

    @Override
    public void generateOnBlock(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, int pass, BlockPos pos, double range) {
        if (world instanceof ServerWorld) {
            Block newBlock = this.blocks[random.nextInt(this.blocks.length)];
            Block prevBlock = world.func_180495_p(pos).func_177230_c();
            boolean replace = false;
            for (Block block : this.blocksToReplace) {
                if (prevBlock != block) continue;
                replace = true;
            }
            if (replace) {
                PBEffectGenReplace.setBlockVarying(world, pos, newBlock, this.unifiedSeed);
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        PBNBTHelper.writeNBTBlocks("blocks", this.blocks, compound);
        PBNBTHelper.writeNBTBlocks("blocksToReplace", this.blocksToReplace, compound);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.blocks = PBNBTHelper.readNBTBlocks("blocks", compound);
        this.blocksToReplace = PBNBTHelper.readNBTBlocks("blocksToReplace", compound);
    }
}

