/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.weighted.WeightedBlock;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PBEffectGenShapes
extends PBEffectGenerateByStructure {
    public PBEffectGenShapes() {
    }

    public PBEffectGenShapes(int maxTicksAlive) {
        super(maxTicksAlive);
    }

    public void setRandomShapes(Random random, Collection<WeightedBlock> blocks, double range, double minSize, double maxSize, int number, int shape) {
        this.structures = new PBEffectGenerateByStructure.Structure[number];
        for (int i = 0; i < this.structures.length; ++i) {
            StructureShape randomShape = this.createStructure();
            PBEffectGenShapes.applyRandomProperties(randomShape, range, random);
            randomShape.shapeType = shape < 0 ? random.nextInt(4) : shape;
            randomShape.size = minSize + random.nextDouble() * (maxSize - minSize);
            randomShape.blocks = PandorasBoxHelper.getRandomBlockList(random, blocks);
            this.structures[i] = randomShape;
        }
    }

    public void setShapes(Random random, Block[] blockSelection, double range, double minSize, double maxSize, int number, int shape, int unifiedSeed) {
        this.structures = new PBEffectGenerateByStructure.Structure[number];
        for (int i = 0; i < this.structures.length; ++i) {
            StructureShape randomShape = this.createStructure();
            PBEffectGenShapes.applyRandomProperties(randomShape, range, random);
            randomShape.shapeType = shape < 0 ? random.nextInt(4) : shape;
            randomShape.size = minSize + random.nextDouble() * (maxSize - minSize);
            randomShape.blocks = (Block[])blockSelection.clone();
            randomShape.unifiedSeed = unifiedSeed;
            this.structures[i] = randomShape;
        }
    }

    @Override
    public void generateStructure(World world, PandorasBoxEntity entity, Random random, PBEffectGenerateByStructure.Structure structure, BlockPos pos, float newRatio, float prevRatio) {
        block12: {
            double newSize;
            double prevSize;
            StructureShape structureShape;
            block14: {
                block13: {
                    if (!(world instanceof ServerWorld)) break block12;
                    structureShape = (StructureShape)structure;
                    prevSize = structureShape.size * (double)prevRatio;
                    newSize = structureShape.size * (double)newRatio;
                    if (structureShape.shapeType != 0) break block13;
                    int requiredRange = MathHelper.func_76128_c((double)newSize);
                    for (int xPlus = -requiredRange; xPlus <= requiredRange; ++xPlus) {
                        for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                            for (int zPlus = -requiredRange; zPlus <= requiredRange; ++zPlus) {
                                double dist = MathHelper.func_76129_c((float)(xPlus * xPlus + yPlus * yPlus + zPlus * zPlus));
                                if (!(dist <= newSize)) continue;
                                if (dist > prevSize) {
                                    this.generateOnBlock(world, entity, random, structureShape, pos.func_177982_a(structure.x + xPlus, structure.y + yPlus, structure.z + zPlus));
                                    continue;
                                }
                                zPlus = -zPlus;
                            }
                        }
                    }
                    break block12;
                }
                if (structureShape.shapeType != 1) break block14;
                int requiredRange = MathHelper.func_76128_c((double)newSize);
                for (int xPlus = -requiredRange; xPlus <= requiredRange; ++xPlus) {
                    for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                        for (int zPlus = -requiredRange; zPlus <= requiredRange; ++zPlus) {
                            double xDist = Math.abs(xPlus);
                            double yDist = Math.abs(yPlus);
                            double zDist = Math.abs(zPlus);
                            if (!(xDist <= newSize) || !(yDist <= newSize) || !(zDist <= newSize)) continue;
                            if (xDist > prevSize || yDist > prevSize || zDist > prevSize) {
                                this.generateOnBlock(world, entity, random, structureShape, pos.func_177982_a(structure.x + xPlus, structure.y + yPlus, structure.z + zPlus));
                                continue;
                            }
                            zPlus = -zPlus;
                        }
                    }
                }
                break block12;
            }
            if (structureShape.shapeType != 2 && structureShape.shapeType != 3) break block12;
            int requiredRange = MathHelper.func_76128_c((double)newSize);
            int totalHeight = MathHelper.func_76128_c((double)structureShape.size);
            for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                int yDist = Math.abs(yPlus);
                if (!((double)yDist <= newSize)) continue;
                if ((double)yDist > prevSize) {
                    int levelSize = structureShape.shapeType == 2 ? totalHeight - yDist : yDist + 1;
                    for (int xPlus = -levelSize; xPlus <= levelSize; ++xPlus) {
                        for (int zPlus = -levelSize; zPlus <= levelSize; ++zPlus) {
                            this.generateOnBlock(world, entity, random, structureShape, pos.func_177982_a(structure.x + xPlus, structure.y + yPlus, structure.z + zPlus));
                        }
                    }
                    continue;
                }
                yPlus = -yPlus;
            }
        }
    }

    public void generateOnBlock(World world, PandorasBoxEntity entity, Random random, StructureShape structure, BlockPos pos) {
        Block block = structure.blocks[random.nextInt(structure.blocks.length)];
        PBEffectGenShapes.setBlockVarying(world, pos, block, structure.unifiedSeed);
    }

    @Override
    public StructureShape createStructure() {
        return new StructureShape();
    }

    public static class StructureShape
    extends PBEffectGenerateByStructure.Structure {
        public Block[] blocks;
        public int shapeType;
        public double size;

        @Override
        public void writeToNBT(CompoundNBT compound) {
            super.writeToNBT(compound);
            PBNBTHelper.writeNBTBlocks("blocks", this.blocks, compound);
            compound.func_74768_a("shapeType", this.shapeType);
            compound.func_74780_a("size", this.size);
        }

        @Override
        public void readFromNBT(CompoundNBT compound) {
            super.readFromNBT(compound);
            this.blocks = PBNBTHelper.readNBTBlocks("blocks", compound);
            this.shapeType = compound.func_74762_e("shapeType");
            this.size = compound.func_74769_h("size");
        }
    }
}

