/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class PBEffectGenStructure
extends PBEffectNormal {
    public int length;
    public int width;
    public int height;
    public int startingYOffset;
    public int unifiedSeed;
    public int x;
    public int y;
    public int z;
    public boolean hasAlreadyStarted = false;
    public boolean grounded = true;
    public BlockPos.Mutable blockPos = new BlockPos.Mutable();

    public PBEffectGenStructure() {
    }

    public PBEffectGenStructure(int maxTicksAlive, int maxX, int maxZ, int maxY, int startY, int unifiedSeed) {
        this(maxTicksAlive, maxX, maxZ, maxY, startY, unifiedSeed, true);
    }

    public PBEffectGenStructure(int maxTicksAlive, int maxX, int maxZ, int maxY, int startY, int unifiedSeed, boolean grounded) {
        super(maxTicksAlive);
        this.length = maxX;
        this.width = maxZ;
        this.height = maxY;
        this.startingYOffset = startY;
        this.grounded = grounded;
        this.unifiedSeed = unifiedSeed;
    }

    @Override
    public void doEffect(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, float prevRatio, float newRatio) {
        if (world.func_201670_d()) {
            return;
        }
        world.func_180495_p((BlockPos)this.blockPos);
        if (!this.hasAlreadyStarted) {
            this.blockPos.func_189532_c(effectCenter.field_72450_a, effectCenter.field_72448_b, effectCenter.field_72449_c);
            BlockState state = world.func_180495_p((BlockPos)this.blockPos);
            if (this.grounded) {
                while (state.func_196958_f()) {
                    this.blockPos.func_196234_d(0, -1, 0);
                    state = world.func_180495_p((BlockPos)this.blockPos);
                }
            }
            this.blockPos.func_196234_d(0, -this.startingYOffset, 0);
            this.x = this.blockPos.func_177958_n() - this.length;
            this.y = this.blockPos.func_177956_o();
            this.z = this.blockPos.func_177952_p() - this.width;
            this.hasAlreadyStarted = true;
        }
        if (this.y <= this.blockPos.func_177956_o() + this.height) {
            if (this.x <= this.blockPos.func_177958_n() + this.length) {
                if (this.z <= this.blockPos.func_177952_p() + this.width) {
                    this.buildStructure(world, entity, new BlockPos(this.x, this.y, this.z), random, prevRatio, newRatio, this.length, this.width, this.height, this.blockPos.func_177956_o(), this.blockPos.func_177958_n(), this.blockPos.func_177952_p());
                    ++this.z;
                } else {
                    this.z = this.blockPos.func_177952_p() - this.width;
                    ++this.x;
                }
            } else {
                this.x = this.blockPos.func_177958_n() - this.length;
                ++this.y;
            }
        }
    }

    public abstract void buildStructure(World var1, PandorasBoxEntity var2, BlockPos var3, Random var4, float var5, float var6, int var7, int var8, int var9, int var10, int var11, int var12);

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("length", this.length);
        compound.func_74768_a("width", this.width);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("x", this.x);
        compound.func_74768_a("y", this.y);
        compound.func_74768_a("z", this.z);
        compound.func_74757_a("alreadyStarted", this.hasAlreadyStarted);
        compound.func_74757_a("grounded", this.grounded);
        compound.func_74768_a("startingYOffset", this.startingYOffset);
        compound.func_74768_a("centerX", this.blockPos.func_177958_n());
        compound.func_74768_a("centerY", this.blockPos.func_177956_o());
        compound.func_74768_a("centerZ", this.blockPos.func_177952_p());
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.length = compound.func_74762_e("length");
        this.width = compound.func_74762_e("width");
        this.height = compound.func_74762_e("height");
        this.x = compound.func_74762_e("x");
        this.y = compound.func_74762_e("y");
        this.z = compound.func_74762_e("z");
        this.blockPos.func_223471_o(compound.func_74762_e("centerX"));
        this.blockPos.func_185336_p(compound.func_74762_e("centerY"));
        this.blockPos.func_223472_q(compound.func_74762_e("centerZ"));
        this.hasAlreadyStarted = compound.func_74767_n("alreadyStarted");
        this.grounded = compound.func_74767_n("grounded");
        this.startingYOffset = compound.func_74762_e("startingYOffset");
    }
}

