/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.worldgen.MegaTreeFeature;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;

public abstract class PBEffectGenerateByGenerator<T>
extends PBEffectGenerate {
    public boolean requiresSolidGround;
    public double chancePerBlock;
    public int generatorFlags;
    protected final ArrayListExtensions<T> treeGens = this.initializeGens();

    public PBEffectGenerateByGenerator() {
    }

    public PBEffectGenerateByGenerator(int time, double range, int unifiedSeed, boolean requiresSolidGround, double chancePerBlock, int generatorFlags) {
        super(time, range, 1, unifiedSeed);
        this.requiresSolidGround = requiresSolidGround;
        this.chancePerBlock = chancePerBlock;
        this.generatorFlags = generatorFlags;
    }

    abstract ArrayListExtensions<T> initializeGens();

    @Override
    public void generateOnBlock(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, int pass, BlockPos pos, double range) {
        if (world instanceof ServerWorld && random.nextDouble() < this.chancePerBlock) {
            BlockState blockState = world.func_180495_p(pos);
            BlockPos posBelow = pos.func_177977_b();
            BlockState blockBelowState = world.func_180495_p(posBelow);
            if (blockState.func_185904_a() == Material.field_151579_a && (!this.requiresSolidGround || blockBelowState.func_215686_e((IBlockReader)world, posBelow))) {
                Object feature;
                PBEffectGenerateByGenerator.setBlockSafe(world, posBelow, Blocks.field_150346_d.func_176223_P());
                T generator = this.getRandomGenerator(this.getGenerators(), this.generatorFlags, random);
                if (generator instanceof ConfiguredFeature) {
                    feature = (ConfiguredFeature)generator;
                    ServerWorld serverWorld = (ServerWorld)world;
                    feature.func_242765_a((ISeedReader)serverWorld, serverWorld.func_72863_F().func_201711_g(), random, pos);
                }
                if (generator instanceof MegaTreeFeature) {
                    feature = (MegaTreeFeature)generator;
                    feature.place((IWorldGenerationReader)world, random, pos);
                }
            }
        }
    }

    public abstract List<T> getGenerators();

    public T getRandomGenerator(List<T> generators, int flags, Random random) {
        int totalNumber = 0;
        for (int i = 0; i < generators.size(); ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            ++totalNumber;
        }
        int chosenGen = random.nextInt(totalNumber);
        for (int i = 0; i < generators.size(); ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            if (chosenGen == 0) {
                return generators.get(i);
            }
            --chosenGen;
        }
        return null;
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74757_a("requiresSolidGround", this.requiresSolidGround);
        compound.func_74780_a("chancePerBlock", this.chancePerBlock);
        compound.func_74768_a("generatorFlags", this.generatorFlags);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.requiresSolidGround = compound.func_74767_n("requiresSolidGround");
        this.chancePerBlock = compound.func_74769_h("chancePerBlock");
        this.generatorFlags = compound.func_74762_e("generatorFlags");
    }
}

