/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class PBEffectGenerateByStructure
extends PBEffectNormal {
    public Structure[] structures;

    public PBEffectGenerateByStructure() {
    }

    public PBEffectGenerateByStructure(int maxTicksAlive) {
        super(maxTicksAlive);
        this.structures = new Structure[0];
    }

    @Override
    public void doEffect(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, float prevRatio, float newRatio) {
        for (Structure structure : this.structures) {
            float newStructureRatio = this.getStructureRatio(newRatio, structure);
            float prevStructureRatio = this.getStructureRatio(prevRatio, structure);
            int baseX = MathHelper.func_76128_c((double)effectCenter.field_72450_a);
            int baseY = MathHelper.func_76128_c((double)effectCenter.field_72448_b);
            int baseZ = MathHelper.func_76128_c((double)effectCenter.field_72449_c);
            if (!(newStructureRatio > prevStructureRatio)) continue;
            this.generateStructure(world, entity, random, structure, new BlockPos(baseX, baseY, baseZ), newStructureRatio, prevStructureRatio);
        }
    }

    private float getStructureRatio(float ratio, Structure structure) {
        return MathHelper.func_76131_a((float)((ratio - structure.structureStart) / structure.structureLength), (float)0.0f, (float)1.0f);
    }

    public abstract void generateStructure(World var1, PandorasBoxEntity var2, Random var3, Structure var4, BlockPos var5, float var6, float var7);

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        ListNBT structureTagList = new ListNBT();
        for (Structure structure : this.structures) {
            CompoundNBT structureCompound = new CompoundNBT();
            structure.writeToNBT(structureCompound);
            structureTagList.add((Object)structureCompound);
        }
        compound.func_218657_a("structures", (INBT)structureTagList);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        ListNBT structureTagList = compound.func_150295_c("structures", 10);
        this.structures = new Structure[structureTagList.size()];
        for (int i = 0; i < this.structures.length; ++i) {
            this.structures[i] = this.createStructure(structureTagList.func_150305_b(i));
        }
    }

    public abstract Structure createStructure();

    public Structure createStructure(CompoundNBT compound) {
        Structure structure = this.createStructure();
        structure.readFromNBT(compound);
        return structure;
    }

    public static void applyRandomProperties(Structure structure, double range, Random random) {
        structure.structureLength = random.nextFloat() * 0.8f + 0.1f;
        structure.structureStart = random.nextFloat() * (1.0f - structure.structureLength);
        structure.x = MathHelper.func_76128_c((double)((random.nextDouble() - random.nextDouble()) * range));
        structure.y = MathHelper.func_76128_c((double)((random.nextDouble() - random.nextDouble()) * range));
        structure.z = MathHelper.func_76128_c((double)((random.nextDouble() - random.nextDouble()) * range));
        structure.unifiedSeed = PandorasBoxHelper.getRandomUnifiedSeed(random);
    }

    public static class Structure {
        public float structureStart;
        public float structureLength;
        public int x;
        public int y;
        public int z;
        public int unifiedSeed;

        public Structure() {
        }

        public Structure(float structureStart, float structureLength, int x, int y, int z, int unifiedSeed) {
            this.structureStart = structureStart;
            this.structureLength = structureLength;
            this.x = x;
            this.y = y;
            this.z = z;
            this.unifiedSeed = unifiedSeed;
        }

        public void writeToNBT(CompoundNBT compound) {
            compound.func_74776_a("structureStart", this.structureStart);
            compound.func_74776_a("structureLength", this.structureLength);
            compound.func_74768_a("x", this.x);
            compound.func_74768_a("y", this.y);
            compound.func_74768_a("z", this.z);
            compound.func_74768_a("unifiedSeed", this.unifiedSeed);
        }

        public void readFromNBT(CompoundNBT compound) {
            this.structureStart = compound.func_74760_g("structureStart");
            this.structureLength = compound.func_74760_g("structureLength");
            this.x = compound.func_74762_e("x");
            this.y = compound.func_74762_e("y");
            this.z = compound.func_74762_e("z");
            this.unifiedSeed = compound.func_74762_e("unifiedSeed");
        }
    }
}

