/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class PBEffectMulti
extends PBEffect {
    public PBEffect[] effects;
    public int[] delays;

    public PBEffectMulti() {
    }

    public PBEffectMulti(PBEffect[] effects, int[] delays) {
        this.effects = effects;
        this.delays = delays;
    }

    @Override
    public void doTick(PandorasBoxEntity entity, Vec3d effectCenter, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            this.effects[i].doTick(entity, effectCenter, effectTicks);
        }
    }

    @Override
    public boolean isDone(PandorasBoxEntity entity, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            if (this.effects[i].isDone(entity, effectTicks)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.effects.length; ++i) {
            CompoundNBT cmp = new CompoundNBT();
            cmp.func_74768_a("delay", this.delays[i]);
            cmp.func_74778_a("pbEffectID", this.effects[i].getEffectID());
            CompoundNBT effectCmp = new CompoundNBT();
            this.effects[i].writeToNBT(effectCmp);
            cmp.func_218657_a("pbEffectCompound", (INBT)effectCmp);
            list.add((Object)cmp);
        }
        compound.func_218657_a("effects", (INBT)list);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        ListNBT list = compound.func_150295_c("effects", 10);
        this.effects = new PBEffect[list.size()];
        this.delays = new int[this.effects.length];
        for (int i = 0; i < this.effects.length; ++i) {
            CompoundNBT cmp = list.func_150305_b(i);
            this.delays[i] = cmp.func_74762_e("delay");
            this.effects[i] = PBEffectRegistry.loadEffect(cmp.func_74779_i("pbEffectID"), cmp.func_74775_l("pbEffectCompound"));
        }
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity entity) {
        for (PBEffect effect : this.effects) {
            if (effect.canGenerateMoreEffectsAfterwards(entity)) continue;
            return false;
        }
        return true;
    }
}

