/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class PBEffectPositionBased
extends PBEffectNormal {
    public int number;
    public double range;

    public PBEffectPositionBased() {
    }

    public PBEffectPositionBased(int time, int number, double range) {
        super(time);
        this.number = number;
        this.range = range;
    }

    @Override
    public void doEffect(World world, PandorasBoxEntity entity, Vec3d effectCenter, Random random, float prevRatio, float newRatio) {
        int prev = this.getSpawnNumber(prevRatio);
        int toSpawn = this.getSpawnNumber(newRatio) - prev;
        for (int i = 0; i < toSpawn; ++i) {
            double eX = effectCenter.field_72450_a + (random.nextDouble() - random.nextDouble()) * this.range;
            double eY = effectCenter.field_72448_b + (random.nextDouble() - random.nextDouble()) * 3.0 * 2.0;
            double eZ = effectCenter.field_72449_c + (random.nextDouble() - random.nextDouble()) * this.range;
            this.doEffect(world, entity, random, newRatio, prevRatio, eX, eY, eZ);
        }
    }

    public abstract void doEffect(World var1, PandorasBoxEntity var2, Random var3, float var4, float var5, double var6, double var8, double var10);

    private int getSpawnNumber(float ratio) {
        return MathHelper.func_76141_d((float)(ratio * (float)this.number));
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("number", this.number);
        compound.func_74780_a("range", this.range);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.number = compound.func_74762_e("number");
        this.range = compound.func_74769_h("range");
    }
}

