/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectPositionBased;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PBEffectRandomExplosions
extends PBEffectPositionBased {
    public float minExplosionStrength;
    public float maxExplosionStrength;
    public boolean isFlaming;
    public boolean isSmoking;

    public PBEffectRandomExplosions() {
    }

    public PBEffectRandomExplosions(int time, int number, double range, float minExplosionStrength, float maxExplosionStrength, boolean isFlaming, boolean isSmoking) {
        super(time, number, range);
        this.minExplosionStrength = minExplosionStrength;
        this.maxExplosionStrength = maxExplosionStrength;
        this.isFlaming = isFlaming;
        this.isSmoking = isSmoking;
    }

    @Override
    public void doEffect(World world, PandorasBoxEntity entity, Random random, float newRatio, float prevRatio, double x, double y, double z) {
        if (world instanceof ServerWorld) {
            world.func_217398_a((Entity)entity, x, y, z, this.minExplosionStrength + random.nextFloat() * (this.maxExplosionStrength - this.minExplosionStrength), this.isFlaming, Explosion.Mode.BREAK);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74776_a("minExplosionStrength", this.minExplosionStrength);
        compound.func_74776_a("maxExplosionStrength", this.maxExplosionStrength);
        compound.func_74757_a("isFlaming", this.isFlaming);
        compound.func_74757_a("isSmoking", this.isSmoking);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.minExplosionStrength = compound.func_74760_g("minExplosionStrength");
        this.maxExplosionStrength = compound.func_74760_g("maxExplosionStrength");
        this.isFlaming = compound.func_74767_n("isFlaming");
        this.isSmoking = compound.func_74767_n("isSmoking");
    }
}

