/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public class PBEffectRegistry {
    private static Hashtable<String, Class<? extends PBEffect>> registeredEffects = new Hashtable();
    public static final List<ResourceLocation> resourceLocationList = new ArrayList<ResourceLocation>();

    public static Class<? extends PBEffect> getEffect(String id) {
        return registeredEffects.get(id);
    }

    public static void register(Class<? extends PBEffect> effect, String id) {
        id = id.toLowerCase();
        resourceLocationList.add(new ResourceLocation("pandorasbox", id));
        registeredEffects.put(id, effect);
    }

    public static Set<String> getAllEffectIDs() {
        return registeredEffects.keySet();
    }

    public static Collection<Class<? extends PBEffect>> getAllEffects() {
        return registeredEffects.values();
    }

    public static void writeEffect(PBEffect effect, CompoundNBT compound) {
        if (effect != null) {
            compound.func_74778_a("pbEffectID", effect.getEffectID());
            CompoundNBT pbEffectCompound = new CompoundNBT();
            effect.writeToNBT(pbEffectCompound);
            compound.func_218657_a("pbEffectCompound", (INBT)pbEffectCompound);
        }
    }

    public static PBEffect loadEffect(CompoundNBT compound) {
        return PBEffectRegistry.loadEffect(compound.func_74779_i("pbEffectID"), compound.func_74775_l("pbEffectCompound"));
    }

    public static PBEffect loadEffect(String id, CompoundNBT compound) {
        Class<? extends PBEffect> clazz = PBEffectRegistry.getEffect(id);
        PBEffect effect = null;
        if (clazz != null) {
            try {
                effect = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (effect != null && compound != null) {
            effect.readFromNBT(compound);
            return effect;
        }
        System.err.println("Pandoras Box: Could not load effect with id '" + id + "'!");
        return null;
    }

    public static String getEffectID(PBEffect effect) {
        Class<?> clazz = effect.getClass();
        for (String id : registeredEffects.keySet()) {
            if (!registeredEffects.get(id).equals(clazz)) continue;
            return id;
        }
        return null;
    }
}

