/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class PBEffectSpawnEntities
extends PBEffectNormal {
    public int number;
    public boolean spawnFromBox;
    public double range;
    public double shiftY;
    public double throwStrengthSideMin;
    public double throwStrengthSideMax;
    public double throwStrengthYMin;
    public double throwStrengthYMax;

    public PBEffectSpawnEntities() {
    }

    public PBEffectSpawnEntities(int time, int number) {
        super(time);
        this.number = number;
    }

    public void setDoesNotSpawnFromBox(double range, double shiftY) {
        this.spawnFromBox = false;
        this.range = range;
        this.shiftY = shiftY;
    }

    public void setDoesSpawnFromBox(double throwStrengthSideMin, double throwStrengthSideMax, double throwStrengthYMin, double throwStrengthYMax) {
        this.spawnFromBox = true;
        this.throwStrengthSideMin = throwStrengthSideMin;
        this.throwStrengthSideMax = throwStrengthSideMax;
        this.throwStrengthYMin = throwStrengthYMin;
        this.throwStrengthYMax = throwStrengthYMax;
    }

    @Override
    public void doEffect(World world, PandorasBoxEntity box, Vec3d effectCenter, Random random, float prevRatio, float newRatio) {
        if (world instanceof ServerWorld) {
            int prev = this.getSpawnNumber(prevRatio);
            int toSpawn = this.getSpawnNumber(newRatio) - prev;
            for (int i = 0; i < toSpawn; ++i) {
                double eZ;
                double eY;
                double eX;
                if (this.spawnFromBox) {
                    eX = box.func_226277_ct_();
                    eY = box.func_226278_cu_();
                    eZ = box.func_226281_cx_();
                } else {
                    eX = box.func_226277_ct_() + (random.nextDouble() - random.nextDouble()) * this.range;
                    eY = box.func_226278_cu_() + (random.nextDouble() - random.nextDouble()) * 3.0 + this.shiftY;
                    eZ = box.func_226281_cx_() + (random.nextDouble() - random.nextDouble()) * this.range;
                }
                Entity newEntity = this.spawnEntity(world, box, random, prev + i, eX, eY, eZ);
                if (newEntity == null || !this.spawnFromBox || newEntity instanceof LivingEntity) continue;
                float dirSide = random.nextFloat() * 2.0f * 3.1415925f;
                double throwStrengthSide = this.throwStrengthSideMin + random.nextDouble() * (this.throwStrengthSideMax - this.throwStrengthSideMin);
                newEntity.func_70024_g((double)MathHelper.func_76126_a((float)dirSide) * throwStrengthSide, this.throwStrengthYMin + random.nextDouble() * (this.throwStrengthYMax - this.throwStrengthYMin), (double)MathHelper.func_76134_b((float)dirSide) * throwStrengthSide);
                newEntity.field_70133_I = true;
            }
        }
    }

    private int getSpawnNumber(float ratio) {
        return MathHelper.func_76141_d((float)(ratio * (float)this.number));
    }

    public abstract Entity spawnEntity(World var1, PandorasBoxEntity var2, Random var3, int var4, double var5, double var7, double var9);

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("number", this.number);
        compound.func_74757_a("spawnFromBox", this.spawnFromBox);
        compound.func_74780_a("range", this.range);
        compound.func_74780_a("shiftY", this.shiftY);
        compound.func_74780_a("throwStrengthSideMin", this.throwStrengthSideMin);
        compound.func_74780_a("throwStrengthSideMax", this.throwStrengthSideMax);
        compound.func_74780_a("throwStrengthYMin", this.throwStrengthYMin);
        compound.func_74780_a("throwStrengthYMax", this.throwStrengthYMax);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.number = compound.func_74762_e("number");
        this.spawnFromBox = compound.func_74767_n("spawnFromBox");
        this.range = compound.func_74769_h("range");
        this.shiftY = compound.func_74769_h("shiftY");
        this.throwStrengthSideMin = compound.func_74769_h("throwStrengthSideMin");
        this.throwStrengthSideMax = compound.func_74769_h("throwStrengthSideMax");
        this.throwStrengthYMin = compound.func_74769_h("throwStrengthYMin");
        this.throwStrengthYMax = compound.func_74769_h("throwStrengthYMax");
    }
}

