/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectSpawnEntities;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.random.PandorasBoxEntityNamer;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.utils.StringConverter;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class PBEffectSpawnEntityIDList
extends PBEffectSpawnEntities {
    public String[][] entityIDs;
    public int nameEntities;
    public int equipLevel;
    public int buffLevel;

    public PBEffectSpawnEntityIDList() {
    }

    public PBEffectSpawnEntityIDList(int time, String[] entityIDs, int nameEntities, int equipLevel, int buffLevel) {
        super(time, entityIDs.length);
        this.entityIDs = this.get2DStringArray(entityIDs);
        this.nameEntities = nameEntities;
        this.equipLevel = equipLevel;
        this.buffLevel = buffLevel;
    }

    public PBEffectSpawnEntityIDList(int time, String[][] entityIDs, int nameEntities, int equipLevel, int buffLevel) {
        super(time, entityIDs.length);
        this.entityIDs = entityIDs;
        this.nameEntities = nameEntities;
        this.equipLevel = equipLevel;
        this.buffLevel = buffLevel;
    }

    private String[][] get2DStringArray(String[] strings) {
        String[][] result = new String[strings.length][1];
        for (int i = 0; i < strings.length; ++i) {
            result[i][0] = strings[i];
        }
        return result;
    }

    @Override
    public Entity spawnEntity(World world, PandorasBoxEntity pbEntity, Random random, int number, double x, double y, double z) {
        if (world.func_201670_d()) {
            return null;
        }
        String[] entityTower = this.entityIDs[number];
        Entity previousEntity = null;
        for (String entityID : entityTower) {
            Entity newEntity = PBEffectSpawnEntityIDList.createEntity(world, pbEntity, random, entityID, x, y, z);
            if (newEntity instanceof LivingEntity) {
                PBEffectSpawnEntityIDList.randomizeEntity(random, pbEntity.func_145782_y(), (LivingEntity)newEntity, this.nameEntities, this.equipLevel, this.buffLevel);
            }
            if (previousEntity != null) {
                world.func_217376_c(previousEntity);
                assert (newEntity != null);
                previousEntity.func_184205_a(newEntity, true);
            }
            previousEntity = newEntity;
        }
        if (previousEntity != null) {
            world.func_217376_c(previousEntity);
        }
        return previousEntity;
    }

    public static void randomizeEntity(Random random, long namingSeed, LivingEntity entityLiving, int nameEntities, int equipLevel, int buffLevel) {
        if (nameEntities == 1) {
            entityLiving.func_200203_b((ITextComponent)PandorasBoxEntityNamer.getRandomName(random));
            entityLiving.func_174805_g(true);
        } else if (nameEntities == 2) {
            entityLiving.func_200203_b((ITextComponent)PandorasBoxEntityNamer.getRandomCasualName(random));
        } else if (nameEntities == 3) {
            entityLiving.func_200203_b((ITextComponent)PandorasBoxEntityNamer.getRandomCasualName(new Random(namingSeed)));
        }
        if (equipLevel > 0) {
            float itemChancePerSlot = 1.0f - 0.5f / (float)equipLevel;
            float upgradeChancePerSlot = 1.0f - 1.0f / (float)equipLevel;
            for (int i = 0; i < 5; ++i) {
                int itemLevel;
                if (!(random.nextFloat() < itemChancePerSlot)) continue;
                for (itemLevel = 0; random.nextFloat() < upgradeChancePerSlot && itemLevel < equipLevel; ++itemLevel) {
                }
                if (i == 0) {
                    ItemStack itemStack = PandorasBoxHelper.getRandomWeaponItemForLevel(random, itemLevel);
                    if (itemStack == null) {
                        itemStack = ItemStack.field_190927_a;
                    }
                    entityLiving.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
                    continue;
                }
                if (i == 4 && random.nextFloat() < 0.2f / (float)equipLevel) {
                    entityLiving.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)(random.nextFloat() < 0.1f ? Blocks.field_196628_cT : Blocks.field_150423_aK)));
                    continue;
                }
                EquipmentSlotType slot = i == 1 ? EquipmentSlotType.LEGS : (i == 2 ? EquipmentSlotType.FEET : EquipmentSlotType.CHEST);
                Item item = MobEntity.func_184636_a((EquipmentSlotType)slot, (int)Math.min(itemLevel, 4));
                if (item != null) {
                    entityLiving.func_184201_a(slot, new ItemStack((IItemProvider)item));
                    continue;
                }
                System.err.println("Pandora's Box: Item not found for slot '" + slot + "', level '" + itemLevel + "'");
            }
        }
        if (buffLevel > 0) {
            ModifiableAttributeInstance attackDamage;
            ModifiableAttributeInstance movementSpeed;
            ModifiableAttributeInstance knockbackResistance;
            ModifiableAttributeInstance health = entityLiving.func_110148_a(Attributes.field_233818_a_);
            if (health != null) {
                double healthMultiplierP = random.nextDouble() * (double)buffLevel * 0.25;
                health.func_233769_c_(new AttributeModifier("Zeus's magic", healthMultiplierP, AttributeModifier.Operation.func_220372_a((int)1)));
            }
            if ((knockbackResistance = entityLiving.func_110148_a(Attributes.field_233820_c_)) != null) {
                double knockbackResistanceP = random.nextDouble() * (double)buffLevel * 0.25;
                knockbackResistance.func_233769_c_(new AttributeModifier("Zeus's magic", knockbackResistanceP, AttributeModifier.Operation.func_220372_a((int)1)));
            }
            if ((movementSpeed = entityLiving.func_110148_a(Attributes.field_233821_d_)) != null) {
                double movementSpeedP = random.nextDouble() * (double)buffLevel * 0.08;
                movementSpeed.func_233769_c_(new AttributeModifier("Zeus's magic", movementSpeedP, AttributeModifier.Operation.func_220372_a((int)1)));
            }
            if ((attackDamage = entityLiving.func_110148_a(Attributes.field_233823_f_)) != null) {
                double attackDamageP = random.nextDouble() * (double)buffLevel * 0.25;
                attackDamage.func_233769_c_(new AttributeModifier("Zeus's magic", attackDamageP, AttributeModifier.Operation.func_220372_a((int)1)));
            }
        }
    }

    public static Entity createEntity(World world, PandorasBoxEntity pbEntity, Random random, String entityID, double x, double y, double z) {
        try {
            if ("pbspecial_XP".equals(entityID)) {
                ExperienceOrbEntity entity = (ExperienceOrbEntity)EntityType.field_200807_u.func_200721_a(world);
                assert (entity != null);
                entity.field_70530_e = 10;
                return entity;
            }
            if ("pbspecial_wolfTamed".equals(entityID)) {
                PlayerEntity nearest = PBEffectSpawnEntityIDList.getPlayer(world, pbEntity);
                WolfEntity wolf = (WolfEntity)EntityType.field_200724_aC.func_200721_a(world);
                assert (wolf != null);
                wolf.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                if (nearest != null) {
                    wolf.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(x, y, z)), SpawnReason.NATURAL, null, null);
                    wolf.func_193101_c(nearest);
                    wolf.func_70661_as().func_75499_g();
                    wolf.func_70624_b(null);
                    wolf.field_70170_p.func_72960_a((Entity)wolf, (byte)7);
                }
                return wolf;
            }
            if ("pbspecial_ocelotTamed".equals(entityID)) {
                PlayerEntity nearest = PBEffectSpawnEntityIDList.getPlayer(world, pbEntity);
                CatEntity ocelot = (CatEntity)EntityType.field_220360_g.func_200721_a(world);
                assert (ocelot != null);
                ocelot.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                if (nearest != null) {
                    ocelot.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(x, y, z)), SpawnReason.NATURAL, null, null);
                    ocelot.func_193101_c(nearest);
                    ocelot.field_70170_p.func_72960_a((Entity)ocelot, (byte)7);
                }
                return ocelot;
            }
            if (entityID.startsWith("pbspecial_tnt")) {
                TNTEntity entitytntprimed = (TNTEntity)EntityType.field_200735_aa.func_200721_a(world);
                assert (entitytntprimed != null);
                entitytntprimed.func_70107_b(x, y, z);
                entitytntprimed.func_184534_a(Integer.parseInt(entityID.substring(13)));
                return entitytntprimed;
            }
            if ("pbspecial_invisibleTnt".startsWith(entityID)) {
                TNTEntity entitytntprimed = (TNTEntity)EntityType.field_200735_aa.func_200721_a(world);
                assert (entitytntprimed != null);
                entitytntprimed.func_70107_b(x, y, z);
                entitytntprimed.func_184534_a(Integer.parseInt(entityID.substring(22)));
                entitytntprimed.func_82142_c(true);
                return entitytntprimed;
            }
            if ("pbspecial_firework".equals(entityID)) {
                ItemStack stack = new ItemStack((IItemProvider)Items.field_196152_dE);
                stack.func_77983_a("Fireworks", (INBT)PBEffectSpawnEntityIDList.createRandomFirework(random));
                FireworkRocketEntity fireworkRocket = (FireworkRocketEntity)EntityType.field_200810_x.func_200721_a(world);
                assert (fireworkRocket != null);
                fireworkRocket.func_70107_b(x, y, z);
                fireworkRocket.func_184212_Q().func_187227_b(PBEffectSpawnEntityIDList.fireworkStackParameter(), (Object)stack);
                return fireworkRocket;
            }
            if ("pbspecial_angryWolf".equals(entityID)) {
                WolfEntity wolf = (WolfEntity)EntityType.field_200724_aC.func_200721_a(world);
                assert (wolf != null);
                wolf.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(x, y, z)), SpawnReason.NATURAL, null, null);
                wolf.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                wolf.func_70624_b((LivingEntity)world.func_217366_a(x, y, z, 40.0, false));
                return wolf;
            }
            if ("pbspecial_superchargedCreeper".equals(entityID)) {
                CreeperEntity creeper = (CreeperEntity)EntityType.field_200797_k.func_200721_a(world);
                assert (creeper != null);
                creeper.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(x, y, z)), SpawnReason.NATURAL, null, null);
                creeper.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                creeper.func_184212_Q().func_187227_b(PBEffectSpawnEntityIDList.creeperPoweredParameter(), (Object)true);
                return creeper;
            }
            if ("pbspecial_skeletonWither".equals(entityID)) {
                WitherSkeletonEntity skeleton = (WitherSkeletonEntity)EntityType.field_200722_aA.func_200721_a(world);
                assert (skeleton != null);
                skeleton.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(x, y, z)), SpawnReason.NATURAL, null, null);
                skeleton.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                skeleton.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151052_q));
                skeleton.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
                return skeleton;
            }
            if ("pbspecial_elderGuardian".equals(entityID)) {
                ElderGuardianEntity entity = (ElderGuardianEntity)EntityType.field_200800_n.func_200721_a(world);
                assert (entity != null);
                entity.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(x, y, z)), SpawnReason.NATURAL, null, null);
                entity.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
                return entity;
            }
            entityID = StringConverter.convertCamelCase(entityID);
            EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityID));
            assert (entity != null);
            Entity entity1 = entity.func_200721_a(world);
            assert (entity1 != null);
            entity1.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
            if (entity1 instanceof AbstractPiglinEntity) {
                ((AbstractPiglinEntity)entity1).func_242340_t(true);
            }
            if (entity1 instanceof HoglinEntity) {
                ((HoglinEntity)entity1).func_234370_t_(true);
            }
            if (entity1 instanceof MobEntity) {
                ((MobEntity)entity1).func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(x, y, z)), SpawnReason.NATURAL, null, null);
            }
            return entity1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static DataParameter<Boolean> creeperPoweredParameter() throws IllegalAccessException {
        return (DataParameter)ObfuscationReflectionHelper.findField(CreeperEntity.class, (String)"field_184714_b").get(null);
    }

    private static DataParameter<ItemStack> fireworkStackParameter() throws IllegalAccessException {
        return (DataParameter)ObfuscationReflectionHelper.findField(FireworkRocketEntity.class, (String)"field_184566_a").get(null);
    }

    public static CompoundNBT createRandomFirework(Random random) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Explosions", (INBT)PBEffectSpawnEntityIDList.createRandomFireworkExplosions(random, random.nextInt(20) != 0 ? 1 : 1 + random.nextInt(2)));
        compound.func_74774_a("Flight", (byte)(random.nextInt(15) != 0 ? 1 : 2 + random.nextInt(2)));
        return compound;
    }

    public static ListNBT createRandomFireworkExplosions(Random random, int number) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < number; ++i) {
            list.add((Object)PBEffectSpawnEntityIDList.createRandomFireworkExplosion(random));
        }
        return list;
    }

    public static CompoundNBT createRandomFireworkExplosion(Random random) {
        CompoundNBT fireworkCompound = new CompoundNBT();
        fireworkCompound.func_74757_a("Flicker", random.nextInt(20) == 0);
        fireworkCompound.func_74757_a("Trail", random.nextInt(30) == 0);
        fireworkCompound.func_74774_a("Type", (byte)(random.nextInt(10) != 0 ? 0 : random.nextInt(4) + 1));
        int[] colors = new int[random.nextInt(15) != 0 ? 1 : random.nextInt(2) + 2];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DyeColor.func_196056_a((int)random.nextInt(16)).ordinal();
        }
        fireworkCompound.func_74783_a("Colors", colors);
        if (random.nextInt(25) == 0) {
            int[] fadeColors = new int[random.nextInt(2) + 1];
            for (int i = 0; i < fadeColors.length; ++i) {
                fadeColors[i] = DyeColor.func_196056_a((int)random.nextInt(16)).ordinal();
            }
            fireworkCompound.func_74783_a("FadeColors", fadeColors);
        }
        return fireworkCompound;
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        PBNBTHelper.writeNBTStrings2D("entityIDs", this.entityIDs, compound);
        compound.func_74768_a("nameEntities", this.nameEntities);
        compound.func_74768_a("equipLevel", this.equipLevel);
        compound.func_74768_a("buffLevel", this.buffLevel);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.entityIDs = PBNBTHelper.readNBTStrings2D("entityIDs", compound);
        this.nameEntities = compound.func_74762_e("nameEntities");
        this.equipLevel = compound.func_74762_e("equipLevel");
        this.buffLevel = compound.func_74762_e("buffLevel");
    }
}

