/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.entitites;

import ivorius.pandorasbox.PBConfig;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.network.PartialUpdateHandler;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class PandorasBoxEntity
extends Entity
implements IEntityAdditionalSpawnData,
PartialUpdateHandler {
    public static final float BOX_UPSCALE_SPEED = 0.02f;
    private static final DataParameter<Integer> BOX_DEATH_TICKS = EntityDataManager.func_187226_a(PandorasBoxEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected int timeBoxWaiting;
    protected int effectTicksExisted;
    protected boolean canGenerateMoreEffectsAfterwards = true;
    protected PBEffect boxEffect;
    protected boolean floatUp = false;
    protected float floatAwayProgress = -1.0f;
    public static final IDataSerializer<PBEffect> PBEFFECT_SERIALIZER = new IDataSerializer<PBEffect>(){

        public void write(PacketBuffer p_187160_1_, PBEffect p_187160_2_) {
            CompoundNBT compound = new CompoundNBT();
            CompoundNBT effectCompound = new CompoundNBT();
            PBEffectRegistry.writeEffect(p_187160_2_, effectCompound);
            compound.func_218657_a("boxEffect", (INBT)effectCompound);
            p_187160_1_.func_150786_a(compound);
        }

        public PBEffect read(PacketBuffer p_187159_1_) {
            return PBEffectRegistry.loadEffect(p_187159_1_.func_150793_b().func_74775_l("boxEffect"));
        }

        public PBEffect copy(PBEffect p_192717_1_) {
            return p_192717_1_;
        }
    };
    protected float scaleInProgress = 1.0f;
    private static final DataParameter<PBEffect> DATA_EFFECT_ID = EntityDataManager.func_187226_a(PandorasBoxEntity.class, PBEFFECT_SERIALIZER);
    protected Vec3d effectCenter = new Vec3d(0.0, 0.0, 0.0);

    public PandorasBoxEntity(EntityType<? extends PandorasBoxEntity> p_i50172_1_, World p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
    }

    public int getTimeBoxWaiting() {
        return this.timeBoxWaiting;
    }

    public boolean func_241849_j(Entity p_241849_1_) {
        return false;
    }

    public boolean func_241845_aY() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void setTimeBoxWaiting(int timeBoxWaiting) {
        this.timeBoxWaiting = timeBoxWaiting;
    }

    public int getEffectTicksExisted() {
        return this.effectTicksExisted;
    }

    public void setEffectTicksExisted(int effectTicksExisted) {
        this.effectTicksExisted = effectTicksExisted;
    }

    public boolean canGenerateMoreEffectsAfterwards() {
        return this.canGenerateMoreEffectsAfterwards;
    }

    public void setCanGenerateMoreEffectsAfterwards(boolean canGenerateMoreEffectsAfterwards) {
        this.canGenerateMoreEffectsAfterwards = canGenerateMoreEffectsAfterwards;
    }

    public boolean floatUp() {
        return this.floatUp;
    }

    public void setFloatUp(boolean floatUp) {
        this.floatUp = floatUp;
    }

    public float getFloatAwayProgress() {
        return this.floatAwayProgress;
    }

    public void setFloatAwayProgress(float floatAwayProgress) {
        this.floatAwayProgress = floatAwayProgress;
    }

    public Vec3d getEffectCenter() {
        return this.effectCenter;
    }

    public void setEffectCenter(double x, double y, double z) {
        this.effectCenter = new Vec3d(x, y, z);
    }

    public float getCurrentScale() {
        return this.scaleInProgress;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BOX_DEATH_TICKS, (Object)-1);
        this.func_184212_Q().func_187214_a(DATA_EFFECT_ID, null);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.timeBoxWaiting == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            if (effect == null) {
                if (this.field_70170_p instanceof ServerWorld) {
                    this.func_70106_y();
                }
            } else if (effect.isDone(this, this.effectTicksExisted)) {
                if (this.field_70170_p instanceof ServerWorld) {
                    boolean isCompletelyDone = true;
                    if (this.canGenerateMoreEffectsAfterwards && effect.canGenerateMoreEffectsAfterwards(this) && (double)this.field_70146_Z.nextFloat() < PBConfig.boxLongevity) {
                        this.startNewEffect();
                        isCompletelyDone = false;
                    }
                    if (isCompletelyDone) {
                        this.startFadingOut();
                    }
                }
            } else {
                if (this.effectTicksExisted == 0) {
                    this.setEffectCenter(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                }
                effect.doTick(this, this.effectCenter, this.effectTicksExisted);
            }
        }
        if (this.timeBoxWaiting == 0) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.95));
        }
        if (this.floatAwayProgress >= 0.0f && this.floatAwayProgress < 1.0f) {
            float speed = MathHelper.func_233022_k_((float)(this.floatAwayProgress - 0.7f));
            if (this.floatUp) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(speed * 0.015f), 0.0));
            } else {
                this.func_213309_a(0.4f, new Vec3d(-0.0, speed * 0.02f, -0.02f));
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(speed * 0.015f), 0.0));
            }
            this.floatAwayProgress += 0.025f;
            if (this.floatAwayProgress > 1.0f) {
                this.stopFloating();
            }
        }
        if (this.scaleInProgress < 1.0f) {
            this.scaleInProgress += 0.02f;
        }
        if (this.scaleInProgress > 1.0f) {
            this.scaleInProgress = 1.0f;
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (this.timeBoxWaiting == 0) {
            if (this.getDeathTicks() < 0) {
                if (!this.func_82150_aj() && this.field_70170_p.func_201670_d()) {
                    double zP;
                    double yDir;
                    double xP;
                    int e;
                    double yCenter = this.func_226278_cu_() + (double)this.func_213302_cg() * 0.5;
                    for (e = 0; e < 2; ++e) {
                        xP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.2;
                        yDir = this.field_70146_Z.nextDouble() * 0.1;
                        zP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.2;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + xP, yCenter, this.func_226281_cx_() + zP, 0.0, yDir, 0.0);
                    }
                    for (e = 0; e < 3; ++e) {
                        double xDir = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 3.0;
                        yDir = this.field_70146_Z.nextDouble() * 4.0 + 2.0;
                        double zDir = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 3.0;
                        double xP2 = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf();
                        double zP2 = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf();
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197623_p, this.func_226277_ct_() + xP2 + xDir, yCenter + yDir, this.func_226281_cx_() + zP2 + zDir, -xDir, -yDir, -zDir);
                    }
                    for (e = 0; e < 4; ++e) {
                        xP = this.field_70146_Z.nextDouble() * 16.0 - 8.0;
                        double yP = this.field_70146_Z.nextDouble() * 5.0 - 2.0;
                        zP = this.field_70146_Z.nextDouble() * 16.0 - 8.0;
                        double xDir = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                        double yDir2 = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                        double zDir = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + xP, yCenter + yP, this.func_226281_cx_() + zP, xDir, yDir2, zDir);
                    }
                }
                ++this.effectTicksExisted;
            }
        } else {
            --this.timeBoxWaiting;
        }
        if (this.getDeathTicks() >= 0) {
            if (this.field_70170_p instanceof ServerWorld) {
                if (this.getDeathTicks() >= 30) {
                    this.func_70106_y();
                }
            } else {
                for (int e = 0; e < Math.min(this.getDeathTicks(), 60); ++e) {
                    double xP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                    double yP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                    double zP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + xP, this.func_226278_cu_() + yP, this.func_226281_cx_() + zP, 0.0, 0.0, 0.0);
                }
            }
            this.setDeathTicks(this.getDeathTicks() + 1);
        }
    }

    public void startNewEffect() {
        this.effectTicksExisted = 0;
        this.timeBoxWaiting = this.field_70146_Z.nextInt(40);
        this.boxEffect = this.ensureNotNull(PBECRegistry.createRandomEffect(this.field_70170_p, this.field_70146_Z, this.effectCenter.field_72450_a, this.effectCenter.field_72448_b, this.effectCenter.field_72449_c, true));
        this.field_70180_af.func_187227_b(DATA_EFFECT_ID, (Object)this.boxEffect);
    }

    public void startFadingOut() {
        this.setDeathTicks(0);
    }

    public void beginFloatingAway() {
        this.floatAwayProgress = 0.0f;
        this.floatUp = false;
    }

    public void beginFloatingUp() {
        this.floatAwayProgress = 0.0f;
        this.floatUp = true;
    }

    public void stopFloating() {
        this.floatAwayProgress = -1.0f;
        this.effectTicksExisted = 0;
    }

    public void beginScalingIn() {
        this.scaleInProgress = 0.0f;
    }

    public PBEffect getBoxEffect() {
        return (PBEffect)this.field_70180_af.func_187225_a(DATA_EFFECT_ID);
    }

    public void setBoxEffect(PBEffect effect) {
        this.boxEffect = this.ensureNotNull(effect);
        this.field_70180_af.func_187227_b(DATA_EFFECT_ID, (Object)this.boxEffect);
    }

    public PBEffect ensureNotNull(PBEffect input) {
        while (input == null) {
            input = PBECRegistry.createRandomEffect(this.field_70170_p, this.field_70146_Z, this.effectCenter.field_72450_a, this.effectCenter.field_72448_b, this.effectCenter.field_72449_c, true);
        }
        return input;
    }

    public Random getRandom() {
        return this.field_70146_Z;
    }

    public int getDeathTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(BOX_DEATH_TICKS);
    }

    public void setDeathTicks(int deathTicks) {
        this.func_184212_Q().func_187227_b(BOX_DEATH_TICKS, (Object)deathTicks);
    }

    public float getRatioBoxOpen(float partialTicks) {
        if (this.floatAwayProgress >= 0.0f) {
            return MathHelper.func_76131_a((float)((this.floatAwayProgress + partialTicks * 0.025f - 0.5f) * 2.0f), (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70108_f(Entity entityIn) {
    }

    public void func_70037_a(CompoundNBT compound) {
        this.readBoxData(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        this.writeBoxData(compound);
    }

    public void readBoxData(CompoundNBT compound) {
        this.setBoxEffect(PBEffectRegistry.loadEffect(compound.func_74775_l("boxEffect")));
        this.effectTicksExisted = compound.func_74762_e("effectTicksExisted");
        this.timeBoxWaiting = compound.func_74762_e("timeBoxWaiting");
        this.canGenerateMoreEffectsAfterwards = compound.func_74767_n("canGenerateMoreEffectsAfterwards");
        this.floatAwayProgress = compound.func_74760_g("floatAwayProgress");
        this.floatUp = compound.func_74767_n("floatUp");
        this.scaleInProgress = compound.func_74760_g("scaleInProgress");
        if (compound.func_150297_b("effectCenterX", 6) && compound.func_150297_b("effectCenterY", 6) && compound.func_150297_b("effectCenterZ", 6)) {
            this.setEffectCenter(compound.func_74769_h("effectCenterX"), compound.func_74769_h("effectCenterY"), compound.func_74769_h("effectCenterZ"));
        } else {
            this.setEffectCenter(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    public void writeBoxData(CompoundNBT compound) {
        CompoundNBT effectCompound = new CompoundNBT();
        PBEffectRegistry.writeEffect(this.getBoxEffect(), effectCompound);
        compound.func_218657_a("boxEffect", (INBT)effectCompound);
        compound.func_74768_a("effectTicksExisted", this.effectTicksExisted);
        compound.func_74768_a("timeBoxWaiting", this.timeBoxWaiting);
        compound.func_74757_a("canGenerateMoreEffectsAfterwards", this.canGenerateMoreEffectsAfterwards);
        compound.func_74776_a("floatAwayProgress", this.floatAwayProgress);
        compound.func_74757_a("floatUp", this.floatUp);
        compound.func_74776_a("scaleInProgress", this.scaleInProgress);
        compound.func_74780_a("effectCenterX", this.effectCenter.field_72450_a);
        compound.func_74780_a("effectCenterY", this.effectCenter.field_72448_b);
        compound.func_74780_a("effectCenterZ", this.effectCenter.field_72449_c);
    }

    @Override
    public void writeUpdateData(PacketBuffer buffer, String context) {
        if (context.equals("boxEffect")) {
            CompoundNBT compound = new CompoundNBT();
            this.writeBoxData(compound);
            buffer.func_150786_a(compound);
        }
    }

    @Override
    public void readUpdateData(PacketBuffer buffer, String context) {
        CompoundNBT compound;
        if (context.equals("boxEffect") && (compound = buffer.func_150793_b()) != null) {
            this.readBoxData(compound);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.writeBoxData(compound);
        buffer.func_150786_a(compound);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        CompoundNBT compound = additionalData.func_150793_b();
        if (compound != null) {
            this.readBoxData(compound);
        }
    }
}

