/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.events;

import com.mojang.brigadier.CommandDispatcher;
import ivorius.pandorasbox.PBConfig;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.commands.CommandPandorasBox;
import ivorius.pandorasbox.effects.PBEffects;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.worldgen.PBLoot;
import net.minecraft.block.Block;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pandorasbox", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PBEventHandler {
    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(ModConfig.ModConfigEvent event) {
        if ((event instanceof ModConfig.Reloading || event instanceof ModConfig.Loading) && event.getConfig().getModId().equals("pandorasbox")) {
            PBConfig.loadConfig();
        }
    }

    @SubscribeEvent
    public void onLoadLootTable(LootTableLoadEvent event) {
        if (PBConfig.allowLootTableInjection) {
            PBLoot.injectLoot(event.getTable(), event.getName());
        }
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent evt) {
        new CommandPandorasBox((CommandDispatcher<CommandSource>)evt.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerInteractAir(PlayerInteractEvent.RightClickEmpty event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            BlockPos pos = event.getPlayer().func_233580_cy_();
            Direction direction = event.getPlayer().func_174811_aO();
            BlockPos frontPos = this.getPosInFront(pos, direction);
            ((BlockItem)item).func_195942_a(new BlockItemUseContext(event.getPlayer(), event.getHand(), stack, new BlockRayTraceResult(new Vector3d((double)frontPos.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.5, (double)frontPos.func_177956_o() + 0.5 + (double)direction.func_96559_d() * 0.5, (double)frontPos.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.5), direction, frontPos, false)));
        }
    }

    @SubscribeEvent
    public void serverInit(FMLServerStartedEvent event) {
        this.initPB();
    }

    @SubscribeEvent
    public void datapackReload(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        this.initPB();
    }

    public void initPB() {
        PandorasBox.logs = new ArrayListExtensions();
        PandorasBox.leaves = new ArrayListExtensions();
        PandorasBox.flowers = new ArrayListExtensions();
        PandorasBox.wool = new ArrayListExtensions();
        PandorasBox.slabs = new ArrayListExtensions();
        PandorasBox.bricks = new ArrayListExtensions();
        PandorasBox.terracotta = new ArrayListExtensions();
        PandorasBox.stained_terracotta = new ArrayListExtensions();
        PandorasBox.planks = new ArrayListExtensions();
        PandorasBox.stained_glass = new ArrayListExtensions();
        PandorasBox.saplings = new ArrayListExtensions();
        PandorasBox.pots = new ArrayListExtensions();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (BlockTags.field_200031_h.func_230235_a_((Object)block)) {
                PandorasBox.logs.add(block);
            }
            if (BlockTags.field_206952_E.func_230235_a_((Object)block)) {
                PandorasBox.leaves.add(block);
            }
            if (BlockTags.field_219746_E.func_230235_a_((Object)block)) {
                PandorasBox.flowers.add(block);
            }
            if (BlockTags.field_199897_a.func_230235_a_((Object)block)) {
                PandorasBox.wool.add(block);
            }
            if (BlockTags.field_203292_x.func_230235_a_((Object)block)) {
                PandorasBox.slabs.add(block);
            }
            if (BlockTags.field_200026_c.func_230235_a_((Object)block)) {
                PandorasBox.bricks.add(block);
            }
            if (block.getRegistryName().func_110623_a().endsWith("terracotta")) {
                PandorasBox.terracotta.add(block);
            }
            if (block.getRegistryName().func_110623_a().endsWith("_terracotta")) {
                PandorasBox.stained_terracotta.add(block);
            }
            if (BlockTags.field_199898_b.func_230235_a_((Object)block)) {
                PandorasBox.planks.add(block);
            }
            if (block instanceof StainedGlassBlock) {
                PandorasBox.stained_glass.add(block);
            }
            if (block instanceof SaplingBlock) {
                PandorasBox.saplings.add(block);
            }
            if (!BlockTags.field_200032_i.func_230235_a_((Object)block)) continue;
            PandorasBox.pots.add(block);
        }
        PBEffects.registerEffectCreators();
    }

    public BlockPos getPosInFront(BlockPos pos, Direction direction) {
        switch (direction) {
            case WEST: {
                return pos.func_177976_e();
            }
            case EAST: {
                return pos.func_177974_f();
            }
            case NORTH: {
                return pos.func_177978_c();
            }
            case SOUTH: {
                return pos.func_177968_d();
            }
        }
        return pos;
    }
}

