/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.utils;

import ivorius.pandorasbox.utils.IterableExtensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ArrayListExtensions<T>
extends ArrayList<T>
implements IterableExtensions<T> {
    @SafeVarargs
    public final boolean addAll(T ... entries) {
        return this.addAll(Arrays.asList(entries));
    }

    @SafeVarargs
    public final boolean addAll(Collection<T> ... entries) {
        boolean bl = true;
        for (Collection<T> entry : entries) {
            bl &= this.addAll(entry);
        }
        return bl;
    }

    @SafeVarargs
    public final boolean addAll(int index, T ... entries) {
        return this.addAll(index, Arrays.asList(entries));
    }

    @SafeVarargs
    public final boolean addAll(int index, Collection<T> ... entries) {
        boolean bl = true;
        for (Collection<T> entry : entries) {
            bl &= this.addAll(index, entry);
        }
        return bl;
    }

    @SafeVarargs
    public final boolean removeAll(T ... entries) {
        return this.removeAll((Collection<?>)Arrays.asList(entries));
    }

    @SafeVarargs
    public final boolean removeAll(Collection<T> ... entries) {
        boolean bl = true;
        for (Collection<T> entry : entries) {
            bl &= this.removeAll((Collection<?>)entry);
        }
        return bl;
    }

    @SafeVarargs
    public final boolean removeAll(int index, T ... entries) {
        return this.removeAll(index, new Collection[]{Arrays.asList(entries)});
    }

    @SafeVarargs
    public final boolean removeAll(int index, Collection<T> ... entries) {
        boolean bl = true;
        for (Collection<T> entry : entries) {
            bl &= this.removeAll(index, entry);
        }
        return bl;
    }
}

