/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PBNBTHelper {
    public static byte readByte(CompoundNBT compound, String key, byte defaultValue) {
        return compound != null && compound.func_150297_b(key, 1) ? compound.func_74771_c(key) : defaultValue;
    }

    public static byte[] readByteArray(CompoundNBT compound, String key, byte[] defaultValue) {
        return compound != null && compound.func_150297_b(key, 7) ? compound.func_74770_j(key) : defaultValue;
    }

    public static double readDouble(CompoundNBT compound, String key, double defaultValue) {
        return compound != null && compound.func_150297_b(key, 6) ? compound.func_74769_h(key) : defaultValue;
    }

    public static float readFloat(CompoundNBT compound, String key, float defaultValue) {
        return compound != null && compound.func_150297_b(key, 5) ? compound.func_74760_g(key) : defaultValue;
    }

    public static int readInt(CompoundNBT compound, String key, int defaultValue) {
        return compound != null && compound.func_150297_b(key, 3) ? compound.func_74762_e(key) : defaultValue;
    }

    public static int[] readIntArray(CompoundNBT compound, String key, int[] defaultValue) {
        return compound != null && compound.func_150297_b(key, 11) ? compound.func_74759_k(key) : defaultValue;
    }

    public static long readLong(CompoundNBT compound, String key, long defaultValue) {
        return compound != null && compound.func_150297_b(key, 4) ? compound.func_74763_f(key) : defaultValue;
    }

    public static short readShort(CompoundNBT compound, String key, short defaultValue) {
        return compound != null && compound.func_150297_b(key, 2) ? compound.func_74765_d(key) : defaultValue;
    }

    public static String readString(CompoundNBT compound, String key, String defaultValue) {
        return compound != null && compound.func_150297_b(key, 8) ? compound.func_74779_i(key) : defaultValue;
    }

    public static double[] readDoubleArray(String key, CompoundNBT compound) {
        if (compound.func_74764_b(key)) {
            ListNBT list = compound.func_150295_c(key, 6);
            double[] array = new double[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = list.func_150309_d(i);
            }
            return array;
        }
        return null;
    }

    public static String[] readNBTStrings(String id, CompoundNBT compound) {
        if (compound.func_74764_b(id)) {
            ListNBT nbtTagList = compound.func_150295_c(id, 8);
            String[] strings = new String[nbtTagList.size()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = nbtTagList.func_150307_f(i);
            }
            return strings;
        }
        return null;
    }

    public static void writeNBTStrings(String id, String[] strings, CompoundNBT compound) {
        if (strings != null) {
            ListNBT nbtTagList = new ListNBT();
            for (String s : strings) {
                nbtTagList.add((Object)StringNBT.func_229705_a_((String)s));
            }
            compound.func_218657_a(id, (INBT)nbtTagList);
        }
    }

    public static ItemStack[] readNBTStacks(String id, CompoundNBT compound) {
        if (compound.func_74764_b(id)) {
            ListNBT nbtTagList = compound.func_150295_c(id, 10);
            ItemStack[] itemStacks = new ItemStack[nbtTagList.size()];
            for (int i = 0; i < itemStacks.length; ++i) {
                itemStacks[i] = ItemStack.func_199557_a((CompoundNBT)(nbtTagList.get(i) instanceof CompoundNBT ? (CompoundNBT)nbtTagList.get(i) : new CompoundNBT()));
            }
            return itemStacks;
        }
        return null;
    }

    public static void writeNBTStacks(String id, ItemStack[] stacks, CompoundNBT compound) {
        if (stacks != null) {
            ListNBT nbtTagList = new ListNBT();
            for (ItemStack stack : stacks) {
                CompoundNBT tagCompound = new CompoundNBT();
                stack.func_77955_b(tagCompound);
                nbtTagList.add((Object)tagCompound);
            }
            compound.func_218657_a(id, (INBT)nbtTagList);
        }
    }

    public static Block[] readNBTBlocks(String id, CompoundNBT compound) {
        if (compound.func_74764_b(id)) {
            ListNBT nbtTagList = compound.func_150295_c(id, 8);
            Block[] blocks = new Block[nbtTagList.size()];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbtTagList.func_150307_f(i)));
            }
            return blocks;
        }
        return null;
    }

    public static void writeNBTBlocks(String id, Block[] blocks, CompoundNBT compound) {
        if (blocks != null) {
            ListNBT nbtTagList = new ListNBT();
            for (Block b : blocks) {
                nbtTagList.add((Object)StringNBT.func_229705_a_((String)PBNBTHelper.storeBlockString(b)));
            }
            compound.func_218657_a(id, (INBT)nbtTagList);
        }
    }

    public static long[] readNBTLongs(String id, CompoundNBT compound) {
        if (compound.func_74764_b(id)) {
            ByteBuf bytes = Unpooled.copiedBuffer((byte[])compound.func_74770_j(id));
            long[] longs = new long[bytes.capacity() / 8];
            for (int i = 0; i < longs.length; ++i) {
                longs[i] = bytes.readLong();
            }
            return longs;
        }
        return null;
    }

    public static void writeNBTLongs(String id, long[] longs, CompoundNBT compound) {
        if (longs != null) {
            ByteBuf bytes = Unpooled.buffer((int)(longs.length * 8));
            for (long aLong : longs) {
                bytes.writeLong(aLong);
            }
            compound.func_74773_a(id, bytes.array());
        }
    }

    public static EffectInstance[] readNBTPotions(String id, CompoundNBT compound) {
        if (compound.func_74764_b(id)) {
            ListNBT nbtTagList = compound.func_150295_c(id, 8);
            EffectInstance[] potions = new EffectInstance[nbtTagList.size()];
            for (int i = 0; i < potions.length; ++i) {
                potions[i] = EffectInstance.func_82722_b((CompoundNBT)nbtTagList.func_150305_b(i));
            }
            return potions;
        }
        return null;
    }

    public static void writeNBTPotions(String id, EffectInstance[] potions, CompoundNBT compound) {
        if (potions != null) {
            ListNBT nbtTagList = new ListNBT();
            for (EffectInstance p : potions) {
                nbtTagList.add((Object)p.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a(id, (INBT)nbtTagList);
        }
    }

    public static int[] readIntArrayFixedSize(String id, int length, CompoundNBT compound) {
        int[] array = compound.func_74759_k(id);
        return array.length != length ? new int[length] : array;
    }

    public static String[][] readNBTStrings2D(String id, CompoundNBT compound) {
        ListNBT nbtTagList = compound.func_150295_c(id, 10);
        String[][] strings = new String[nbtTagList.size()][];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = PBNBTHelper.readNBTStrings("Strings", nbtTagList.func_150305_b(i));
        }
        return strings;
    }

    public static void writeNBTStrings2D(String id, String[][] strings, CompoundNBT compound) {
        ListNBT nbtTagList = new ListNBT();
        for (String[] s : strings) {
            CompoundNBT compound1 = new CompoundNBT();
            PBNBTHelper.writeNBTStrings("Strings", s, compound1);
            nbtTagList.add((Object)compound1);
        }
        compound.func_218657_a(id, (INBT)nbtTagList);
    }

    public static String storeBlockString(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        return location == null ? "minecraft:air" : location.toString();
    }

    public static Block getBlock(String string) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
    }
}

