/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.worldgen;

import com.mojang.serialization.Codec;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.worldgen.AccessibleTreeFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;

public class WorldGenLollipop
extends TreeFeature
implements AccessibleTreeFeature {
    public static int[] metas;
    public static Block soil;
    public final int addition;

    public WorldGenLollipop(Codec<BaseTreeFeatureConfig> configIn, int addition) {
        super(configIn);
        this.addition = addition;
    }

    @Override
    public void setMetas(int[] newMetas) {
        metas = newMetas;
    }

    @Override
    public void setSoil(Block newSoil) {
        soil = newSoil;
    }

    @Override
    public boolean place(IWorldGenerationReader worldIn, Random rand, BlockPos position) {
        int l = rand.nextInt(this.addition) + 5;
        ArrayListExtensions blocks = new ArrayListExtensions();
        blocks.addAll(PandorasBox.wool);
        World world = worldIn instanceof World ? (World)worldIn : null;
        boolean flag = true;
        int par3 = position.func_177958_n();
        int par4 = position.func_177956_o();
        int par5 = position.func_177952_p();
        if (world == null) {
            return false;
        }
        if (par4 >= 1 && par4 + l + 1 <= 256) {
            boolean isSoil;
            for (int i1 = par4; i1 <= par4 + 1 + l; ++i1) {
                flag = i1 >= 0 && i1 < 256;
            }
            if (!flag) {
                return false;
            }
            BlockPos pos = new BlockPos(par3, par4 - 1, par5);
            BlockState block2State = world.func_180495_p(pos);
            Block block2 = block2State.func_177230_c();
            boolean rotated = rand.nextBoolean();
            boolean bl = isSoil = block2 == soil;
            if (isSoil && par4 < 256 - l - 1) {
                block2.onPlantGrow(block2State, (IWorld)world, pos, new BlockPos(par3, par4, par5));
                for (int shift = -1; shift <= 1; ++shift) {
                    for (int s = -l / 2; s <= l / 2; ++s) {
                        for (int y = -l / 2; y <= l / 2; ++y) {
                            int z;
                            int rY;
                            int x;
                            BlockPos pos1;
                            BlockState block1State;
                            Block block1;
                            if (s * s + y * y > l * l / 4 - shift * shift * 4 || !(block1 = (block1State = world.func_180495_p(pos1 = new BlockPos(x = (!rotated ? s : shift) + par3, rY = y + par4 + l, z = (rotated ? s : shift) + par5))).func_177230_c()).isAir(block1State, (IBlockReader)world, pos1) && !block1.func_203417_a((ITag)BlockTags.field_206952_E)) continue;
                            this.func_230367_a_((IWorldWriter)worldIn, pos1, ((Block)blocks.get(metas[rand.nextInt(metas.length)])).func_176223_P());
                        }
                    }
                }
                for (int k2 = 0; k2 < l; ++k2) {
                    BlockPos pos1 = new BlockPos(par3, par4 + k2, par5);
                    BlockState block3State = world.func_180495_p(pos1);
                    Block block3 = block3State.func_177230_c();
                    if (!block3State.isAir((IBlockReader)world, pos1) && !block3.func_203417_a((ITag)BlockTags.field_206952_E)) continue;
                    this.func_230367_a_((IWorldWriter)worldIn, pos1, ((Block)blocks.get(metas[0])).func_176223_P());
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

