/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.init.Registry;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.weighted.WeightedBlock;
import ivorius.pandorasbox.weighted.WeightedEntity;
import ivorius.pandorasbox.weighted.WeightedPotion;
import ivorius.pandorasbox.weighted.WeightedSelector;
import ivorius.pandorasbox.weighted.WeightedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class PandorasBoxHelper {
    public static List<WeightedEntity> mobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> creatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterCreatures = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> waterMobs = new ArrayList<WeightedEntity>();
    public static List<WeightedEntity> tameableCreatures = new ArrayList<WeightedEntity>();
    public static List<RandomizedItemStack> blocksAndItems = new ArrayList<RandomizedItemStack>();
    public static Multimap<Block, Property<?>> randomizableBlockProperties = HashMultimap.create();
    public static List<WeightedBlock> blocks = new ArrayList<WeightedBlock>();
    public static List<RandomizedItemStack> items = new ArrayList<RandomizedItemStack>();
    public static List<WeightedSet> equipmentSets = new ArrayList<WeightedSet>();
    public static Hashtable<Item, Hashtable<Integer, ItemStack>> equipmentForLevels = new Hashtable();
    public static List<WeightedPotion> buffs = new ArrayList<WeightedPotion>();
    public static List<WeightedPotion> debuffs = new ArrayList<WeightedPotion>();
    public static List<RandomizedItemStack> enchantableArmorList = new ArrayList<RandomizedItemStack>();
    public static List<RandomizedItemStack> enchantableToolList = new ArrayList<RandomizedItemStack>();
    public static List<WeightedBlock> heavyBlocks = new ArrayList<WeightedBlock>();

    public static void addEntities(List<WeightedEntity> list, double weight, int minNumber, int maxNumber, String ... entities) {
        for (String s : entities) {
            list.add(new WeightedEntity(weight, s, minNumber, maxNumber));
        }
    }

    public static void addBlocks(double weight, Block ... blocks) {
        for (Block block : blocks) {
            PandorasBoxHelper.blocks.add(new WeightedBlock(weight, block));
            Item item = block.m_5456_();
            if (item == null) continue;
            PandorasBoxHelper.addItem(new RandomizedItemStack(item, 1, item.getMaxStackSize(new ItemStack((ItemLike)item)), weight));
        }
    }

    public static void addBlocks(double weight, List<Block> blocks) {
        for (Block block : blocks) {
            PandorasBoxHelper.blocks.add(new WeightedBlock(weight, block));
            Item item = block.m_5456_();
            if (item == null) continue;
            PandorasBoxHelper.addItem(new RandomizedItemStack(item, 1, item.getMaxStackSize(new ItemStack((ItemLike)item)), weight));
        }
    }

    public static void addBlocks(List<WeightedBlock> list, double weight, Block ... blocks) {
        for (Block block : blocks) {
            list.add(new WeightedBlock(weight, block));
        }
    }

    public static void addItem(RandomizedItemStack RandomizedItemStack2) {
        items.add(RandomizedItemStack2);
        blocksAndItems.add(RandomizedItemStack2);
    }

    public static void addItems(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, 1, item.getMaxStackSize(new ItemStack((ItemLike)item)), weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, 1, itemStack.m_41720_().getMaxStackSize(itemStack), weight));
        }
    }

    public static void addItemsMinMax(double weight, int min, int max, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                PandorasBoxHelper.addItem(new RandomizedItemStack(item, min, max, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            PandorasBoxHelper.addItem(new RandomizedItemStack(itemStack, min, max, weight));
        }
    }

    public static void addEquipmentSet(double weight, Object ... items) {
        ItemStack[] set = new ItemStack[items.length];
        for (int i = 0; i < set.length; ++i) {
            ItemStack itemStack;
            if (items[i] instanceof Item) {
                Item item = (Item)items[i];
                set[i] = new ItemStack((ItemLike)item);
                continue;
            }
            if (!(items[i] instanceof ItemStack)) continue;
            set[i] = itemStack = (ItemStack)items[i];
        }
        equipmentSets.add(new WeightedSet(weight, set));
    }

    public static void addPotions(List<WeightedPotion> list, double weight, int minStrength, int maxStrength, int minDuration, int maxDuration, MobEffect ... potions) {
        for (MobEffect effect : potions) {
            list.add(new WeightedPotion(weight, effect, minStrength, maxStrength, minDuration, maxDuration));
        }
    }

    public static void addEnchantableArmor(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableArmorList.add(new RandomizedItemStack(item, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableArmorList.add(new RandomizedItemStack(itemStack, 1, 1, weight));
        }
    }

    public static void addEnchantableTools(double weight, Object ... items) {
        for (Object object : items) {
            if (object instanceof Item) {
                Item item = (Item)object;
                enchantableToolList.add(new RandomizedItemStack(item, 1, 1, weight));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            enchantableToolList.add(new RandomizedItemStack(itemStack, 1, 1, weight));
        }
    }

    public static void addEquipmentForLevel(Item base, int level, ItemStack stack) {
        if (!equipmentForLevels.containsKey(base)) {
            equipmentForLevels.put(base, new Hashtable());
        }
        equipmentForLevels.get(base).put(level, stack);
    }

    public static void addEquipmentLevelsInOrder(Item base, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object instanceof Item) {
                PandorasBoxHelper.addEquipmentForLevel(base, i, new ItemStack((ItemLike)((Item)items[i])));
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            PandorasBoxHelper.addEquipmentForLevel(base, i, (ItemStack)items[i]);
        }
    }

    public static void addAllRandomizableBlockProperties(List<Block> blocks) {
        for (Block block : blocks) {
            randomizableBlockProperties.putAll((Object)block, (Iterable)block.m_49966_().m_61147_());
        }
    }

    public static void addRandomizableBlockProperty(Block[] blocks, Property ... properties) {
        for (Block block : blocks) {
            for (Property property : properties) {
                randomizableBlockProperties.put((Object)block, (Object)property);
            }
        }
    }

    public static void addRandomizableBlockProperty(Block block, Property ... properties) {
        for (Property property : properties) {
            randomizableBlockProperties.put((Object)block, (Object)property);
        }
    }

    public static void initialize() {
        mobs = new ArrayList<WeightedEntity>();
        creatures = new ArrayList<WeightedEntity>();
        waterCreatures = new ArrayList<WeightedEntity>();
        waterMobs = new ArrayList<WeightedEntity>();
        tameableCreatures = new ArrayList<WeightedEntity>();
        blocks = new ArrayList<WeightedBlock>();
        randomizableBlockProperties = HashMultimap.create();
        blocksAndItems = new ArrayList<RandomizedItemStack>();
        items = new ArrayList<RandomizedItemStack>();
        equipmentSets = new ArrayList<WeightedSet>();
        equipmentForLevels = new Hashtable();
        buffs = new ArrayList<WeightedPotion>();
        debuffs = new ArrayList<WeightedPotion>();
        enchantableArmorList = new ArrayList<RandomizedItemStack>();
        enchantableToolList = new ArrayList<RandomizedItemStack>();
        heavyBlocks = new ArrayList<WeightedBlock>();
        PandorasBoxHelper.addEntities(mobs, 10.0, 3, 10, "zombie", "drowned");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 8, "spider");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 5, "skeleton");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 5, "pbspecial_skeletonWither");
        PandorasBoxHelper.addEntities(mobs, 10.0, 2, 8, "creeper");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "slime");
        PandorasBoxHelper.addEntities(mobs, 4.0, 1, 4, "ghast");
        PandorasBoxHelper.addEntities(mobs, 4.0, 1, 4, "phantom");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "zombified_piglin");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "hoglin");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 8, "zoglin");
        PandorasBoxHelper.addEntities(mobs, 6.0, 2, 6, "enderman");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 4, "cave_spider");
        PandorasBoxHelper.addEntities(mobs, 5.0, 10, 20, "silverfish");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 5, "blaze");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 6, "magma_cube");
        PandorasBoxHelper.addEntities(mobs, 1.0, 1, 1, "wither");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 4, "witch");
        PandorasBoxHelper.addEntities(mobs, 6.0, 10, 20, "endermite");
        PandorasBoxHelper.addEntities(mobs, 5.0, 2, 6, "pbspecial_angryWolf");
        PandorasBoxHelper.addEntities(mobs, 4.0, 2, 5, "pbspecial_superchargedCreeper");
        PandorasBoxHelper.addEntities(creatures, 10.0, 3, 10, "pig", "sheep", "cow", "chicken");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "wolf");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "panda");
        PandorasBoxHelper.addEntities(creatures, 6.0, 2, 6, "fox");
        PandorasBoxHelper.addEntities(creatures, 5.0, 4, 10, "bat");
        PandorasBoxHelper.addEntities(creatures, 7.0, 6, 20, "rabbit");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "mooshroom");
        PandorasBoxHelper.addEntities(creatures, 4.0, 3, 7, "snow_golem");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 5, "horse");
        PandorasBoxHelper.addEntities(creatures, 4.0, 2, 6, "ocelot", "cat");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "villager");
        PandorasBoxHelper.addEntities(creatures, 3.0, 3, 6, "piglin");
        PandorasBoxHelper.addEntities(creatures, 3.0, 2, 4, "iron_golem");
        PandorasBoxHelper.addEntities(waterCreatures, 6.0, 3, 10, "squid", "cod", "salmon", "pufferfish", "turtle", "tropical_fish");
        PandorasBoxHelper.addEntities(waterMobs, 6.0, 3, 10, "guardian");
        PandorasBoxHelper.addEntities(waterMobs, 5.0, 1, 1, "pbspecial_elderGuardian");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_wolfTamed");
        PandorasBoxHelper.addEntities(tameableCreatures, 4.0, 1, 4, "pbspecial_ocelotTamed");
        ArrayListExtensions<Block> planks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> glass = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> randomizable = new ArrayListExtensions<Block>();
        ArrayListExtensions<Item> misc = new ArrayListExtensions<Item>();
        ArrayListExtensions records = new ArrayListExtensions();
        ArrayListExtensions dyes = new ArrayListExtensions();
        glass.addAll(Blocks.f_49997_, Blocks.f_50059_, Blocks.f_50173_, Blocks.f_50331_, Blocks.f_50058_);
        planks.addAll(Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_152550_, Blocks.f_152496_, Blocks.f_50062_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_50394_);
        randomizable.addAll(Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_152550_, Blocks.f_152496_, Blocks.f_50493_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_50194_, Blocks.f_50333_, Blocks.f_50284_, Blocks.f_50472_, Blocks.f_50637_, Blocks.f_50062_, Blocks.f_50263_, Blocks.f_50394_, Blocks.f_50397_, Blocks.f_50156_, Blocks.f_50094_, Blocks.f_50133_, Blocks.f_50144_, Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50087_, Blocks.f_50265_, Blocks.f_50325_, Blocks.f_50056_);
        planks.addAll(new Collection[]{PandorasBox.planks, PandorasBox.logs, PandorasBox.leaves, PandorasBox.wool, PandorasBox.slabs, PandorasBox.bricks, PandorasBox.stained_terracotta});
        randomizable.addAll(new Collection[]{PandorasBox.planks, PandorasBox.logs, PandorasBox.leaves, PandorasBox.wool, PandorasBox.slabs, PandorasBox.bricks, PandorasBox.stained_terracotta, PandorasBox.stained_glass, PandorasBox.saplings, PandorasBox.pots});
        glass.addAll(Blocks.f_50135_, Blocks.f_50136_);
        glass.addAll(PandorasBox.stained_glass);
        misc.addAll(Items.f_42448_, Items.f_42455_, Items.f_42447_, Items.f_42409_, Items.f_42487_, Items.f_42618_, Items.f_42449_, Items.f_42544_);
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (stack.m_204117_(ItemTags.f_13155_) || stack.m_204117_(ItemTags.f_13146_)) {
                misc.add(item);
            }
            if (stack.m_204117_(ItemTags.f_13158_)) {
                records.add(item);
            }
            if (!(item instanceof DyeItem)) continue;
            dyes.add(item);
        }
        PandorasBoxHelper.addBlocks(40.0, planks);
        PandorasBoxHelper.addBlocks(15.0, Blocks.f_50377_, Blocks.f_50333_);
        PandorasBoxHelper.addBlocks(10.0, Blocks.f_50652_, Blocks.f_50079_, Blocks.f_50134_, Blocks.f_50197_, Blocks.f_50076_, Blocks.f_50259_, Blocks.f_50443_, Blocks.f_50352_);
        PandorasBoxHelper.addBlocks(10.0, Blocks.f_50493_, Blocks.f_50034_, Blocks.f_49994_, Blocks.f_50133_, Blocks.f_50129_, Blocks.f_50195_);
        PandorasBoxHelper.addBlocks(8.0, glass);
        PandorasBoxHelper.addBlocks(0.2, Blocks.f_50090_, Blocks.f_50268_, Blocks.f_50074_);
        PandorasBoxHelper.addBlocks(0.3, Blocks.f_50075_);
        PandorasBoxHelper.addBlocks(0.5, Blocks.f_50089_, Blocks.f_50264_, Blocks.f_49995_);
        PandorasBoxHelper.addBlocks(1.0, Blocks.f_49996_);
        PandorasBoxHelper.addBlocks(2.0, Blocks.f_50077_, Blocks.f_50141_, Blocks.f_50353_, Blocks.f_50060_, Blocks.f_50330_, Blocks.f_50374_, Blocks.f_50056_);
        PandorasBoxHelper.addBlocks(5.0, Blocks.f_50260_, Blocks.f_50261_, Blocks.f_50386_, Blocks.f_50125_, Blocks.f_50078_, Blocks.f_50144_, Blocks.f_50335_, Blocks.f_50080_, Blocks.f_50186_);
        PandorasBoxHelper.addItems(10.0, Items.f_42413_, Items.f_42403_, Items.f_42405_, Items.f_42450_, Items.f_42451_, Items.f_42500_, Items.f_42028_, Items.f_42461_, Items.f_42517_, Items.f_42587_, Items.f_42620_, Items.f_42446_, Items.f_42398_, Items.f_42401_, Items.f_42578_, Items.f_42577_, Items.f_42404_, Items.f_42452_, Items.f_42501_, Items.f_42523_, Items.f_42686_, Items.f_42588_, Items.f_42484_, Items.f_42521_, Items.f_42460_, Items.f_42516_, Items.f_42000_);
        PandorasBoxHelper.addItems(10.0, Registry.PBI.get());
        PandorasBoxHelper.addItems(10.0, Items.f_42581_, Items.f_42582_, Items.f_42579_, Items.f_42687_, Items.f_42580_, Items.f_42400_, Items.f_42583_, Items.f_42619_, Items.f_42485_, Items.f_42486_, Items.f_42410_, Items.f_42502_, Items.f_42406_, Items.f_42572_, Items.f_42526_, Items.f_42530_, Items.f_42527_, Items.f_42531_, Items.f_42529_, Items.f_42658_, Items.f_42659_, Items.f_42697_, Items.f_42648_, Items.f_42649_, Items.f_42699_, Items.f_42698_);
        PandorasBoxHelper.addItems(8.0, misc);
        PandorasBoxHelper.addItems(8.0, Items.f_42656_);
        PandorasBoxHelper.addItems(6.0, Items.f_42416_, Items.f_42525_, Items.f_42593_, Items.f_42585_, Items.f_42524_, Items.f_42586_, Items.f_42545_, Items.f_42546_, Items.f_42591_, Items.f_42592_, Items.f_42542_, Items.f_42677_);
        PandorasBoxHelper.addItems(4.0, Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_, Items.f_42420_, Items.f_42422_, Items.f_42421_, Items.f_42423_, Items.f_42424_);
        PandorasBoxHelper.addItems(4.0, Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42430_, Items.f_42432_, Items.f_42431_, Items.f_42433_, Items.f_42434_);
        PandorasBoxHelper.addItems(4.0, Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_, Items.f_42383_, Items.f_42385_, Items.f_42384_, Items.f_42386_, Items.f_42387_);
        PandorasBoxHelper.addItems(3.0, Items.f_42651_, Items.f_42652_);
        PandorasBoxHelper.addItems(2.0, Items.f_42653_);
        PandorasBoxHelper.addItemsMinMax(2.0, 1, 1, Items.f_42065_, Items.f_42146_, Items.f_42543_, Items.f_41855_, Items.f_42108_, Items.f_41984_, Items.f_42100_);
        PandorasBoxHelper.addItemsMinMax(5.0, 1, 1, Items.f_42009_, Items.f_42768_);
        PandorasBoxHelper.addItems(2.0, Items.f_42415_, Items.f_42616_, Items.f_42417_, Items.f_42436_, Items.f_42584_, Items.f_42696_, Items.f_42695_);
        PandorasBoxHelper.addItems(2.0, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42388_, Items.f_42390_, Items.f_42389_, Items.f_42391_, Items.f_42392_);
        PandorasBoxHelper.addItems(2.0, records);
        for (Item dye : dyes) {
            PandorasBoxHelper.addItems(10.0, new ItemStack((ItemLike)dye, 1));
        }
        PandorasBoxHelper.addEquipmentSet(10.0, Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_, Items.f_42420_, Items.f_42422_, Items.f_42421_, Items.f_42423_, Items.f_42424_);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_, Items.f_42383_, Items.f_42385_, Items.f_42384_, Items.f_42386_, Items.f_42387_);
        PandorasBoxHelper.addEquipmentSet(4.0, Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42430_, Items.f_42432_, Items.f_42431_, Items.f_42433_, Items.f_42434_);
        PandorasBoxHelper.addEquipmentSet(2.0, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42388_, Items.f_42390_, Items.f_42389_, Items.f_42391_, Items.f_42392_);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.f_42411_, new ItemStack((ItemLike)Items.f_42412_, 64), Items.f_42468_, Items.f_42408_, Items.f_42462_, Items.f_42463_, Items.f_42386_, new ItemStack((ItemLike)Items.f_42410_, 8));
        PandorasBoxHelper.addEquipmentSet(6.0, Items.f_42468_, Items.f_42408_, Items.f_42462_, Items.f_42463_, Items.f_42390_, Items.f_42384_, Items.f_42386_, Items.f_42425_, new ItemStack((ItemLike)Items.f_42406_, 8), new ItemStack((ItemLike)Items.f_42000_, 32));
        PandorasBoxHelper.addEquipmentSet(8.0, Items.f_42407_, Items.f_42387_, new ItemStack((ItemLike)Items.f_42404_, 32), new ItemStack((ItemLike)Items.f_42577_, 4), new ItemStack((ItemLike)Items.f_42578_, 4), new ItemStack((ItemLike)Items.f_42494_, 8), new ItemStack((ItemLike)Items.f_42329_, 32), Items.f_42447_, Items.f_42447_);
        PandorasBoxHelper.addEquipmentSet(6.0, Items.f_42468_, Items.f_42391_, new ItemStack((ItemLike)Items.f_42579_, 16));
        for (Block block : PandorasBox.wool) {
            if (!(RandomSource.m_216327_().m_188500_() > 0.8)) continue;
            PandorasBoxHelper.addEquipmentSet(6.0, new ItemStack((ItemLike)Items.f_42451_, 64), new ItemStack((ItemLike)block, 16), new ItemStack((ItemLike)block, 16), new ItemStack((ItemLike)block, 16), new ItemStack((ItemLike)Blocks.f_50330_, 8), new ItemStack((ItemLike)Blocks.f_50174_, 8));
        }
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.f_42420_, Items.f_42420_, Items.f_42430_, Items.f_42425_, Items.f_42383_, Items.f_42388_);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.f_42423_, Items.f_42423_, Items.f_42433_, Items.f_42428_, Items.f_42386_, Items.f_42391_);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.f_42422_, Items.f_42422_, Items.f_42432_, Items.f_42427_, Items.f_42385_, Items.f_42390_);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.f_42421_, Items.f_42421_, Items.f_42431_, Items.f_42426_, Items.f_42384_, Items.f_42389_);
        PandorasBoxHelper.addEquipmentLevelsInOrder(Items.f_42424_, Items.f_42424_, Items.f_42434_, Items.f_42429_, Items.f_42387_, Items.f_42392_);
        PandorasBoxHelper.addPotions(buffs, 10.0, 0, 3, 1200, 12000, MobEffects.f_19605_, MobEffects.f_19596_, MobEffects.f_19600_, MobEffects.f_19603_, MobEffects.f_19606_, MobEffects.f_19608_, MobEffects.f_19607_, MobEffects.f_19611_, MobEffects.f_19609_, MobEffects.f_19617_);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 3, 1200, 12000, MobEffects.f_19610_, MobEffects.f_19604_, MobEffects.f_19599_, MobEffects.f_19613_, MobEffects.f_19612_);
        PandorasBoxHelper.addPotions(debuffs, 10.0, 0, 2, 600, 1200, MobEffects.f_19615_);
        PandorasBoxHelper.addEnchantableArmor(10.0, Items.f_42468_, Items.f_42476_, Items.f_42472_, Items.f_42469_, Items.f_42477_, Items.f_42473_, Items.f_42470_, Items.f_42478_, Items.f_42474_, Items.f_42471_, Items.f_42479_, Items.f_42475_);
        PandorasBoxHelper.addEnchantableTools(10.0, Items.f_42383_, Items.f_42430_, Items.f_42388_, Items.f_42384_, Items.f_42431_, Items.f_42389_, Items.f_42385_, Items.f_42432_, Items.f_42390_, Items.f_42386_, Items.f_42433_, Items.f_42391_, Items.f_42411_);
        PandorasBoxHelper.addBlocks(heavyBlocks, 10.0, Blocks.f_50322_);
        PandorasBoxHelper.addAllRandomizableBlockProperties(randomizable);
    }

    public static int getRandomUnifiedSeed(RandomSource random) {
        return Math.abs(random.m_188502_());
    }

    private static <T> T randomElement(Collection<T> collection, RandomSource random) {
        int num = random.m_188503_(collection.size());
        int i = 0;
        for (T t : collection) {
            if (i++ != num) continue;
            return t;
        }
        throw new InternalError();
    }

    public static BlockState getRandomBlockState(RandomSource rand, Block block, int unified) {
        BlockState state = block.m_49966_();
        Collection randomizableProperties = randomizableBlockProperties.get((Object)block);
        if (randomizableProperties != null) {
            if (unified >= 0) {
                rand = RandomSource.m_216335_((long)(unified ^ rand.m_188503_(256)));
            }
            for (Property property : randomizableProperties) {
                state = (BlockState)state.m_61124_(property, (Comparable)PandorasBoxHelper.randomElement(property.m_6908_(), rand));
            }
        }
        return state;
    }

    public static Block[] getRandomBlockList(RandomSource rand, Collection<WeightedBlock> selection) {
        int number;
        for (number = 1; number < 10 && rand.m_188501_() < 0.7f; ++number) {
        }
        int[] weights = new int[number];
        for (int i = 0; i < number; ++i) {
            weights[i] = 1;
            while (weights[i] < 10 && rand.m_188501_() < 0.7f) {
                int n = i;
                weights[n] = weights[n] + 1;
            }
        }
        int total = 0;
        for (int i : weights) {
            total += i;
        }
        Block[] blocks = new Block[total];
        int blockIndex = 0;
        for (int i = 0; i < number; ++i) {
            Block block = WeightedSelector.selectItem((RandomSource)rand, selection).block;
            for (int j = 0; j < weights[i]; ++j) {
                blocks[blockIndex] = block;
                ++blockIndex;
            }
        }
        return blocks;
    }

    public static Block getRandomBlock(RandomSource rand, Collection<WeightedBlock> randomBlockList) {
        if (randomBlockList != null && randomBlockList.size() > 0) {
            return WeightedSelector.selectItem((RandomSource)rand, randomBlockList).block;
        }
        return WeightedSelector.selectItem((RandomSource)rand, PandorasBoxHelper.blocks).block;
    }

    public static WeightedEntity[] getRandomEntityList(RandomSource rand, Collection<WeightedEntity> selection) {
        WeightedEntity[] entities = new WeightedEntity[rand.m_188503_(5) + 1];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = PandorasBoxHelper.getRandomEntityFromList(rand, selection);
        }
        return entities;
    }

    public static WeightedEntity getRandomEntityFromList(RandomSource rand, Collection<WeightedEntity> entityList) {
        return WeightedSelector.selectItem(rand, entityList);
    }

    public static ItemStack getRandomWeaponItemForLevel(RandomSource random, int level) {
        Set<Item> itemSet = equipmentForLevels.keySet();
        Item[] itemArray = itemSet.toArray(new Item[itemSet.size()]);
        return PandorasBoxHelper.getWeaponItemForLevel(itemArray[random.m_188503_(itemArray.length)], level);
    }

    public static ItemStack getWeaponItemForLevel(Item baseItem, int level) {
        Hashtable<Integer, ItemStack> levels = equipmentForLevels.get(baseItem);
        if (levels != null) {
            while (level > 0) {
                if (levels.containsKey(level)) {
                    return levels.get(level);
                }
                --level;
            }
        }
        return null;
    }
}

