/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import ivorius.pandorasbox.client.rendering.PandorasBoxModel;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PandorasBoxRenderer<T extends PandorasBoxEntity>
extends EntityRenderer<T> {
    public PandorasBoxModel model;
    public ResourceLocation texture = new ResourceLocation("pandorasbox", "textures/entity/pandoras_box.png");

    public PandorasBoxRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.model = new PandorasBoxModel(renderManager.m_174023_(PandorasBoxModel.LAYER_LOCATION));
        this.f_114477_ = 0.6f;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLightIn) {
        PBEffectRenderer renderer;
        super.m_7392_(entity, entityYaw, partialTicks, matrixStack, renderTypeBuffer, packedLightIn);
        matrixStack.m_85836_();
        this.model.PBE = entity;
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-entityYaw));
        PBEffect effect = ((PandorasBoxEntity)entity).getBoxEffect();
        boolean visible = !entity.m_20145_();
        VertexConsumer builder = renderTypeBuffer.m_6299_(Objects.requireNonNull(this.model.m_103119_(this.getTextureLocation(entity))));
        if (!effect.isDone((PandorasBoxEntity)entity, ((PandorasBoxEntity)entity).getEffectTicksExisted()) && ((PandorasBoxEntity)entity).getDeathTicks() < 0 && (renderer = PBEffectRenderingRegistry.rendererForEffect(effect)) != null) {
            renderer.renderBox((PandorasBoxEntity)entity, effect, partialTicks, matrixStack, builder);
        }
        if (visible) {
            float boxScale = ((PandorasBoxEntity)entity).getCurrentScale();
            if (boxScale < 1.0f) {
                matrixStack.m_85841_(boxScale, boxScale, boxScale);
            }
            matrixStack.m_252880_(0.0f, 1.5f, 0.0f);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            Arrow emptyEntity = new Arrow(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            emptyEntity.m_146926_(((PandorasBoxEntity)entity).getRatioBoxOpen(partialTicks) * 120.0f / 180.0f * 3.1415925f);
            int i = OverlayTexture.f_118083_;
            this.model.setupAnim(emptyEntity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f);
            this.model.m_7695_(matrixStack, builder, packedLightIn, i, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(T var1) {
        return this.texture;
    }
}

