/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ivorius.pandorasbox.PBConfig;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.init.Registry;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.utils.StringConverter;
import ivorius.pandorasbox.utils.WrappedBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class PBECRegistry {
    public static final int MAX_DELAY_IN_MULTIEFFECT = 60;
    private static final ArrayList<String> goodCreators = new ArrayList();
    private static final ArrayList<String> badCreators = new ArrayList();
    private static final Map<String, Float> fixedChanceCreators = new HashMap<String, Float>();
    private static final WrappedBiMap<ResourceLocation, PBEffectCreator> effectCreators = new WrappedBiMap(HashBiMap.create());

    public static void register(PBEffectCreator creator, String id, boolean good) {
        id = StringConverter.convertCamelCase(id);
        (good ? goodCreators : badCreators).add(id);
        PandorasBox.logger.info("Effect Name: " + id);
        effectCreators.put(new ResourceLocation("pandorasbox", id), creator);
    }

    public static void register(PBEffectCreator creator, String id, float fixedChance) {
        id = StringConverter.convertCamelCase(id);
        fixedChanceCreators.put(id, Float.valueOf(fixedChance));
        effectCreators.put(new ResourceLocation("pandorasbox", id), creator);
    }

    public static String getID(PBEffectCreator creator) {
        return ((ResourceLocation)effectCreators.inverse().get(creator)).toString();
    }

    public static PBEffectCreator effectCreatorWithName(String name) {
        name = StringConverter.convertCamelCase(name);
        return (PBEffectCreator)effectCreators.get(new ResourceLocation(name));
    }

    public static BiMap<ResourceLocation, PBEffectCreator> getEffectCreators() {
        return (BiMap)effectCreators.map();
    }

    public static boolean hasEffect(String name) {
        name = StringConverter.convertCamelCase(name);
        return effectCreators.containsKey(new ResourceLocation(name));
    }

    public static boolean isEffectGood(String name) {
        return goodCreators.contains(name);
    }

    public static boolean isEffectBad(String name) {
        return badCreators.contains(name);
    }

    public static PBEffectCreator randomEffectCreatorOfType(RandomSource random, boolean good) {
        ArrayList<String> list = good ? goodCreators : badCreators;
        return (PBEffectCreator)effectCreators.get(new ResourceLocation("pandorasbox", list.get(random.m_188503_(list.size()))));
    }

    public static PBEffect createEffect(Level world, RandomSource random, double x, double y, double z, PBEffectCreator creator) {
        if (!PBECRegistry.isAnyNull(world, random, creator)) {
            return PBECRegistry.constructEffectSafe(creator, world, x, y, z, random);
        }
        return null;
    }

    public static PBEffect createRandomEffectOfType(Level world, RandomSource random, double x, double y, double z, boolean good) {
        PBEffectCreator creator = PBECRegistry.randomEffectCreatorOfType(random, good);
        if (creator != null) {
            return PBECRegistry.constructEffectSafe(creator, world, x, y, z, random);
        }
        return null;
    }

    public static PBEffect createRandomEffect(Level world, RandomSource random, double x, double y, double z, boolean multi) {
        float currentMinChance = 1.0f;
        ArrayList<PBEffect> effects = new ArrayList<PBEffect>();
        do {
            PBEffect effect;
            PBEffectCreator creator = null;
            for (String fixedChanceCreator : fixedChanceCreators.keySet()) {
                if (!(random.m_188501_() < fixedChanceCreators.get(fixedChanceCreator).floatValue())) continue;
                creator = (PBEffectCreator)effectCreators.get(new ResourceLocation("pandorasbox", fixedChanceCreator));
                break;
            }
            if (creator == null) {
                creator = PBECRegistry.randomEffectCreatorOfType(random, (double)random.m_188501_() < PBConfig.goodEffectChance);
            }
            if ((effect = PBECRegistry.constructEffectSafe(creator, world, x, y, z, random)) != null) {
                effects.add(effect);
            }
            currentMinChance = Math.min(currentMinChance, creator.chanceForMoreEffects(world, x, y, z, random));
        } while ((double)random.m_188501_() < PBECRegistry.newEffectChance(currentMinChance) && effects.size() < PBConfig.maxEffectsPerBox && multi);
        if (effects.size() == 1) {
            return (PBEffect)effects.get(0);
        }
        PBEffect[] effectArray = effects.toArray(new PBEffect[effects.size()]);
        int[] delays = new int[effectArray.length];
        for (int i = 1; i < delays.length; ++i) {
            delays[i] = random.m_188503_(60);
        }
        return new PBEffectMulti(effectArray, delays);
    }

    private static double newEffectChance(double effectFactor) {
        return Math.pow(effectFactor, 1.0 / PBConfig.boxIntensity);
    }

    public static PBEffect constructEffectSafe(PBEffectCreator creator, Level world, double x, double y, double z, RandomSource random) {
        return creator.constructEffect(world, x, y, z, random);
    }

    public static PandorasBoxEntity spawnPandorasBox(Level world, RandomSource random, boolean multi, Entity entity, BlockPos pos, boolean floatAway) {
        PBEffect effect = PBECRegistry.createRandomEffect(world, random, pos.m_123341_(), (double)pos.m_123342_() + 1.2, pos.m_123343_(), multi);
        return PBECRegistry.spawnPandorasBox(world, effect, entity, pos, floatAway);
    }

    public static PandorasBoxEntity spawnPandorasBox(Level world, RandomSource random, boolean multi, Entity entity) {
        PBEffect effect = PBECRegistry.createRandomEffect(world, random, entity.m_20185_(), entity.m_20186_() + 1.2, entity.m_20189_(), multi);
        return PBECRegistry.spawnPandorasBox(world, effect, entity, null, true);
    }

    public static PandorasBoxEntity spawnPandorasBox(Level world, RandomSource random, PBEffectCreator creator, Entity entity) {
        PBEffect effect = PBECRegistry.createEffect(world, random, entity.m_20185_(), entity.m_20186_() + 1.2, entity.m_20189_(), creator);
        return PBECRegistry.spawnPandorasBox(world, effect, entity, null, true);
    }

    public static PandorasBoxEntity spawnPandorasBox(Level world, PBEffect effect, Entity entity, BlockPos pos, boolean floatAway) {
        if (effect != null && !world.m_5776_()) {
            PandorasBoxEntity entityPandorasBox = (PandorasBoxEntity)((EntityType)Registry.Box.get()).m_20615_(world);
            if (pos == null) {
                pos = new BlockPos((int)(entity.m_20185_() + (double)entity.m_6350_().m_122429_()), (int)(entity.m_20186_() + (double)entity.m_6350_().m_122430_()), (int)(entity.m_20189_() + (double)entity.m_6350_().m_122431_()));
            }
            while (!world.m_8055_(pos).m_60795_()) {
                pos = pos.m_7494_();
            }
            assert (entityPandorasBox != null);
            entityPandorasBox.setBoxEffect(effect);
            entityPandorasBox.setTimeBoxWaiting(40);
            entityPandorasBox.m_20035_(pos, entity.m_146908_() + 180.0f, 0.0f);
            if (floatAway) {
                entityPandorasBox.beginFloatingAway();
            } else {
                entityPandorasBox.beginFloatingUp();
            }
            world.m_7967_((Entity)entityPandorasBox);
            return entityPandorasBox;
        }
        return null;
    }

    public static Set<String> getAllIDs() {
        HashSet<String> set = new HashSet<String>();
        effectCreators.keySet().forEach(location -> set.add(location.toString()));
        return set;
    }

    public static ArrayListExtensions<ResourceLocation> getAllIDsAsRL() {
        Set set = effectCreators.keySet();
        ArrayListExtensions<ResourceLocation> resourceLocationList = new ArrayListExtensions<ResourceLocation>();
        resourceLocationList.addAll(set);
        return resourceLocationList;
    }

    public static boolean isAnyNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    public static String[] getIDArray() {
        Set<String> allIDs = PBECRegistry.getAllIDs();
        return allIDs.toArray(new String[allIDs.size()]);
    }
}

