/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectGenReplace;
import ivorius.pandorasbox.random.DValue;
import ivorius.pandorasbox.random.ZValue;
import ivorius.pandorasbox.weighted.WeightedBlock;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PBECReplace
implements PBEffectCreator {
    public DValue range;
    public Block[] srcBlocks;
    public Collection<WeightedBlock> destBlocks;
    public ZValue takeRandomNearbyBlocks;

    public PBECReplace(DValue range, Block[] srcBlocks, Collection<WeightedBlock> destBlocks, ZValue takeRandomNearbyBlocks) {
        this.range = range;
        this.srcBlocks = srcBlocks;
        this.destBlocks = destBlocks;
        this.takeRandomNearbyBlocks = takeRandomNearbyBlocks;
    }

    @Override
    public PBEffect constructEffect(Level world, double x, double y, double z, RandomSource random) {
        double range = this.range.getValue(random);
        int time = Mth.m_14107_((double)((random.m_188500_() * 7.0 + 3.0) * range));
        int baseX = Mth.m_14107_((double)x);
        int baseY = Mth.m_14107_((double)y);
        int baseZ = Mth.m_14107_((double)z);
        boolean takeRandomNearbyBlocks = this.takeRandomNearbyBlocks.getValue(random);
        Block[] srcSelection = new Block[]{};
        if (takeRandomNearbyBlocks) {
            ArrayList<WeightedBlock> nearbyBlocks = new ArrayList<WeightedBlock>();
            for (int xP = -5; xP <= 5; ++xP) {
                for (int yP = -5; yP <= 5; ++yP) {
                    for (int zP = -5; zP <= 5; ++zP) {
                        BlockState block = world.m_8055_(new BlockPos(baseX + xP, baseY + yP, baseZ + zP));
                        if (block.m_60795_()) continue;
                        nearbyBlocks.add(new WeightedBlock(100.0, block.m_60734_()));
                    }
                }
            }
            if (nearbyBlocks.size() > 0) {
                srcSelection = PandorasBoxHelper.getRandomBlockList(random, nearbyBlocks);
            }
        } else {
            srcSelection = (Block[])this.srcBlocks.clone();
        }
        Block[] destSelection = PandorasBoxHelper.getRandomBlockList(random, this.destBlocks);
        PBEffectGenReplace genReplace = new PBEffectGenReplace(time, range, PandorasBoxHelper.getRandomUnifiedSeed(random), destSelection, srcSelection);
        return genReplace;
    }

    @Override
    public float chanceForMoreEffects(Level world, double x, double y, double z, RandomSource random) {
        return 0.1f;
    }
}

