/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import ivorius.pandorasbox.effectcreators.PBECSpawnEntities;
import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectSpawnItemStacks;
import ivorius.pandorasbox.random.DConstant;
import ivorius.pandorasbox.random.DLinear;
import ivorius.pandorasbox.random.IValue;
import ivorius.pandorasbox.random.PandorasBoxItemNamer;
import ivorius.pandorasbox.random.ValueSpawn;
import ivorius.pandorasbox.random.ValueThrow;
import ivorius.pandorasbox.utils.RandomizedItemStack;
import ivorius.pandorasbox.weighted.WeightedSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PBECSpawnItems
implements PBEffectCreator {
    public IValue number;
    public IValue ticksPerItem;
    public List<RandomizedItemStack> items;
    public ValueThrow valueThrow;
    public ValueSpawn valueSpawn;

    public PBECSpawnItems(IValue number, IValue ticksPerItem, List<RandomizedItemStack> items, ValueThrow valueThrow, ValueSpawn valueSpawn) {
        this.number = number;
        this.ticksPerItem = ticksPerItem;
        this.items = items;
        this.valueThrow = valueThrow;
        this.valueSpawn = valueSpawn;
    }

    public PBECSpawnItems(IValue number, IValue ticksPerItem, List<RandomizedItemStack> items) {
        this(number, ticksPerItem, items, PBECSpawnItems.defaultThrow(), null);
    }

    public static ValueThrow defaultThrow() {
        return new ValueThrow(new DLinear(0.05, 0.2), new DLinear(0.2, 1.0));
    }

    public static ValueSpawn defaultShowerSpawn() {
        return new ValueSpawn(new DLinear(5.0, 30.0), new DConstant(150.0));
    }

    public static PBEffect constructEffect(RandomSource random, ItemStack[] stacks, int time, ValueThrow valueThrow, ValueSpawn valueSpawn) {
        boolean canThrow;
        boolean canSpawn = valueSpawn != null;
        boolean bl = canThrow = valueThrow != null;
        if (canThrow && (!canSpawn || random.m_188499_())) {
            PBEffectSpawnItemStacks effect = new PBEffectSpawnItemStacks(time, stacks);
            PBECSpawnEntities.setEffectThrow(effect, random, valueThrow);
            return effect;
        }
        if (canSpawn) {
            PBEffectSpawnItemStacks effect = new PBEffectSpawnItemStacks(time, stacks);
            PBECSpawnEntities.setEffectSpawn(effect, random, valueSpawn);
            return effect;
        }
        throw new RuntimeException("Both spawnRange and throwStrength are null!");
    }

    public static ItemStack[] getItemStacks(RandomSource random, List<RandomizedItemStack> items, int number, boolean split, boolean mixUp, int enchantLevel, boolean giveNames) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < number; ++i) {
            RandomizedItemStack wrcc = mixUp ? WeightedSelector.selectItem(random, items) : items.get(i);
            ItemStack stack = wrcc.itemStack.m_41777_();
            stack.m_41764_(wrcc.min + random.m_188503_(wrcc.max - wrcc.min + 1));
            if (enchantLevel > 0) {
                List enchantments = EnchantmentHelper.m_220297_((RandomSource)random, (ItemStack)stack, (int)enchantLevel, (boolean)false);
                if (enchantments.size() == 0) {
                    enchantments = EnchantmentHelper.m_220297_((RandomSource)random, (ItemStack)new ItemStack((ItemLike)Items.f_42386_), (int)enchantLevel, (boolean)false);
                }
                if (enchantments.size() > 0) {
                    Iterator iterator = enchantments.iterator();
                    while (iterator.hasNext()) {
                        EnchantmentInstance enchantment;
                        EnchantmentInstance enchantmentdata = enchantment = (EnchantmentInstance)iterator.next();
                        if (stack.m_41720_() == Items.f_42690_) {
                            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)enchantmentdata);
                            continue;
                        }
                        stack.m_41663_(enchantmentdata.f_44947_, enchantmentdata.f_44948_);
                    }
                }
            }
            if (giveNames) {
                stack.m_41714_(PandorasBoxItemNamer.getRandomName(random));
            }
            if (split) {
                for (int n = 0; n < stack.m_41613_(); ++n) {
                    ItemStack splitStack = stack.m_41620_(1);
                    list.add(splitStack);
                }
                continue;
            }
            list.add(stack);
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    @Override
    public PBEffect constructEffect(Level world, double x, double y, double z, RandomSource random) {
        int number = this.number.getValue(random);
        int ticksPerItem = this.ticksPerItem.getValue(random);
        ItemStack[] stacks = PBECSpawnItems.getItemStacks(random, this.items, number, random.m_188503_(3) != 0, true, 0, false);
        return PBECSpawnItems.constructEffect(random, stacks, number * ticksPerItem + 1, this.valueThrow, this.valueSpawn);
    }

    @Override
    public float chanceForMoreEffects(Level world, double x, double y, double z, RandomSource random) {
        return 0.1f;
    }
}

