/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;

public final class BlockPositions {
    private BlockPositions() {
    }

    public static BlockPos fromIntArray(int[] array) {
        if (array.length != 3) {
            throw new IllegalArgumentException();
        }
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static int[] toIntArray(BlockPos pos) {
        return new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
    }

    public static BlockPos readWithBase(CompoundTag compound, String keyBase) {
        return new BlockPos(compound.m_128451_(keyBase + "_x"), compound.m_128451_(keyBase + "_y"), compound.m_128451_(keyBase + "_z"));
    }

    public static void writeToNBT(String keyBase, BlockPos coord, CompoundTag compound) {
        if (coord != null) {
            compound.m_128405_(keyBase + "_x", coord.m_123341_());
            compound.m_128405_(keyBase + "_y", coord.m_123342_());
            compound.m_128405_(keyBase + "_z", coord.m_123343_());
        }
    }

    public static BlockPos readFromNBT(String keyBase, CompoundTag compound) {
        return compound.m_128441_(keyBase + "_x") && compound.m_128441_(keyBase + "_y") && compound.m_128441_(keyBase + "_z") ? new BlockPos(compound.m_128451_(keyBase + "_x"), compound.m_128451_(keyBase + "_y"), compound.m_128451_(keyBase + "_z")) : null;
    }

    public static void maybeWriteToBuffer(BlockPos coord, ByteBuf buffer) {
        buffer.writeBoolean(coord != null);
        if (coord != null) {
            BlockPositions.writeToBuffer(coord, buffer);
        }
    }

    public static BlockPos maybeReadFromBuffer(ByteBuf buffer) {
        return buffer.readBoolean() ? BlockPositions.readFromBuffer(buffer) : null;
    }

    public static void writeToBuffer(BlockPos coord, ByteBuf buffer) {
        buffer.writeInt(coord.m_123341_());
        buffer.writeInt(coord.m_123342_());
        buffer.writeInt(coord.m_123343_());
    }

    public static BlockPos readFromBuffer(ByteBuf buffer) {
        return new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static BlockPos getLowerCorner(Collection<BlockPos> positions) {
        int x = 0;
        int y = 0;
        int z = 0;
        boolean first = true;
        for (BlockPos position : positions) {
            if (first) {
                x = position.m_123341_();
                y = position.m_123342_();
                z = position.m_123343_();
                first = false;
            }
            x = Math.min(x, position.m_123341_());
            y = Math.min(y, position.m_123342_());
            z = Math.min(z, position.m_123343_());
        }
        if (first) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos getHigherCorner(Collection<BlockPos> positions) {
        int x = 0;
        int y = 0;
        int z = 0;
        boolean first = true;
        for (BlockPos position : positions) {
            if (first) {
                x = position.m_123341_();
                y = position.m_123342_();
                z = position.m_123343_();
                first = false;
            }
            x = Math.max(x, position.m_123341_());
            y = Math.max(y, position.m_123342_());
            z = Math.max(z, position.m_123343_());
        }
        if (first) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos getLowerCorner(BlockPos one, BlockPos two) {
        return new BlockPos(Math.min(one.m_123341_(), two.m_123341_()), Math.min(one.m_123342_(), two.m_123342_()), Math.min(one.m_123343_(), two.m_123343_()));
    }

    public static BlockPos getHigherCorner(BlockPos one, BlockPos two) {
        return new BlockPos(Math.max(one.m_123341_(), two.m_123341_()), Math.max(one.m_123342_(), two.m_123342_()), Math.max(one.m_123343_(), two.m_123343_()));
    }

    public static BlockPos invert(BlockPos pos) {
        return new BlockPos(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_());
    }

    public static BlockPos sub(BlockPos pos, BlockPos sub) {
        return new BlockPos(pos.m_123341_() - sub.m_123341_(), pos.m_123342_() - sub.m_123342_(), pos.m_123343_() - sub.m_123343_());
    }

    public static AABB expandToAABB(BlockPos pos, double x, double y, double z) {
        return new AABB(pos).m_82363_(x, y, z);
    }
}

