/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.PBEffectSpawnEntityIDList;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PBEffect {
    public String getEffectID() {
        return PBEffectRegistry.getEffectID(this);
    }

    public static boolean setBlockToAirSafe(Level world, BlockPos pos) {
        boolean safeDest = world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60800_((BlockGetter)world, pos) >= 0.0f;
        return safeDest && world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public static boolean setBlockSafe(Level world, BlockPos pos, BlockState state) {
        boolean safeDest = world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60800_((BlockGetter)world, pos) >= 0.0f;
        boolean safeSrc = state.m_60795_() || state.m_60800_((BlockGetter)world, pos) >= 0.0f;
        return safeDest && safeSrc && world.m_46597_(pos, state);
    }

    public static boolean setBlockUnsafeSrc(Level world, BlockPos pos, BlockState state) {
        boolean safeDest = world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60800_((BlockGetter)world, pos) >= 0.0f;
        return safeDest && world.m_46597_(pos, state);
    }

    public static boolean setBlockVarying(Level world, BlockPos pos, Block block, int unified) {
        return PBEffect.setBlockSafe(world, pos, PandorasBoxHelper.getRandomBlockState(world.f_46441_, block, unified));
    }

    public static boolean setBlockVaryingUnsafeSrc(Level world, BlockPos pos, Block block, int unified) {
        return PBEffect.setBlockUnsafeSrc(world, pos, PandorasBoxHelper.getRandomBlockState(world.f_46441_, block, unified));
    }

    public static Player getRandomNearbyPlayer(Level world, PandorasBoxEntity box) {
        List players = world.m_45976_(Player.class, box.m_20191_().m_82363_(30.0, 30.0, 30.0));
        return (Player)players.get(box.getRandom().m_188503_(players.size()));
    }

    public static Player getPlayer(Level world, PandorasBoxEntity box) {
        return PBEffect.getRandomNearbyPlayer(world, box);
    }

    public static boolean isBlockAnyOf(Block block, Block ... blocks) {
        for (Block block1 : blocks) {
            if (block != block1) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockAnyOf(Block block, List<Block> blocks) {
        for (Block block1 : blocks) {
            if (block != block1) continue;
            return true;
        }
        return false;
    }

    public static Entity lazilySpawnEntity(Level world, PandorasBoxEntity box, RandomSource random, String entityID, float chance, BlockPos pos) {
        Entity entity;
        if (random.m_188501_() < chance && !world.m_5776_() && (entity = PBEffectSpawnEntityIDList.createEntity(world, box, random, entityID, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5)) != null) {
            return entity;
        }
        return null;
    }

    public static Entity lazilySpawnFlyingEntity(Level world, PandorasBoxEntity box, RandomSource random, String entityID, float chance, BlockPos pos) {
        Entity entity = PBEffect.lazilySpawnEntity(world, box, random, entityID, chance, pos);
        if (entity != null) {
            world.m_7967_(entity);
        }
        return entity;
    }

    public static boolean canSpawnEntity(Level world, BlockState block, BlockPos pos, Entity entity) {
        if (entity == null) {
            return false;
        }
        if (world.m_5776_()) {
            return false;
        }
        if (block.m_60739_((BlockGetter)world, pos) > 0) {
            return false;
        }
        if (world.m_46575_(pos.m_7495_(), entity) && !world.m_5776_()) {
            world.m_7967_(entity);
            return true;
        }
        return false;
    }

    public boolean canSpawnFlyingEntity(Level world, BlockState block, BlockPos pos) {
        if (world.m_5776_()) {
            return false;
        }
        return block.m_60739_((BlockGetter)world, pos) <= 0 && world.m_8055_(pos.m_7495_()).m_60739_((BlockGetter)world, pos.m_7495_()) <= 0 && world.m_8055_(pos.m_6625_(2)).m_60739_((BlockGetter)world, pos.m_6625_(2)) <= 0;
    }

    public void addPotionEffectDuration(LivingEntity entity, Potion potionEffect) {
        for (MobEffectInstance effectInstance : potionEffect.m_43488_()) {
            MobEffectInstance prevEffect;
            if (!entity.m_7301_(effectInstance)) continue;
            boolean addNewEffect = true;
            if (entity.m_21023_(effectInstance.m_19544_()) && (prevEffect = entity.m_21124_(effectInstance.m_19544_())).m_19564_() == effectInstance.m_19564_()) {
                int duration = prevEffect.m_19557_() + effectInstance.m_19557_();
                MobEffectInstance combined = new MobEffectInstance(effectInstance.m_19544_(), duration, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_());
                entity.m_7292_(combined);
            }
            entity.m_7292_(effectInstance);
        }
    }

    public abstract void doTick(PandorasBoxEntity var1, Vec3d var2, int var3);

    public abstract boolean isDone(PandorasBoxEntity var1, int var2);

    public abstract void writeToNBT(CompoundTag var1);

    public abstract void readFromNBT(CompoundTag var1);

    public abstract boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity var1);
}

