/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.init.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class PBEffectDuplicateBox
extends PBEffectNormal {
    public static final int MODE_BOX_IN_BOX = 0;
    public int spawnMode;

    public PBEffectDuplicateBox() {
    }

    public static int timeNeededForSpawnMode(int mode) {
        if (mode == 0) {
            return 60;
        }
        return 0;
    }

    public PBEffectDuplicateBox(int spawnMode) {
        super(PBEffectDuplicateBox.timeNeededForSpawnMode(spawnMode));
        this.spawnMode = spawnMode;
    }

    @Override
    public void setUpEffect(Level world, PandorasBoxEntity box, Vec3d effectCenter, RandomSource random) {
        if (world instanceof ServerLevel) {
            PBEffect effect = PBECRegistry.createRandomEffect(world, random, box.m_20185_(), box.m_20186_(), box.m_20189_(), true);
            PandorasBoxEntity newBox = (PandorasBoxEntity)((EntityType)Registry.Box.get()).m_20615_(world);
            assert (newBox != null);
            newBox.setBoxEffect(effect);
            newBox.setTimeBoxWaiting(40);
            newBox.m_7678_(box.m_20185_(), box.m_20186_(), box.m_20189_(), box.m_146908_(), box.m_146909_());
            if (this.spawnMode == 0) {
                newBox.beginFloatingUp();
                newBox.beginScalingIn();
                world.m_7967_((Entity)newBox);
            }
        }
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("spawnMode", this.spawnMode);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.spawnMode = compound.m_128451_("spawnMode");
    }
}

