/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;

public class PBEffectEntitiesBuff
extends PBEffectEntityBased {
    public MobEffectInstance[] effects;

    public PBEffectEntitiesBuff() {
    }

    public PBEffectEntitiesBuff(int maxTicksAlive, double range, MobEffectInstance[] effects) {
        super(maxTicksAlive, range);
        this.effects = effects;
    }

    @Override
    public void affectEntity(Level world, PandorasBoxEntity box, RandomSource random, LivingEntity entity, double newRatio, double prevRatio, double strength) {
        for (MobEffectInstance effect : this.effects) {
            int prevDuration = Mth.m_14107_((double)(prevRatio * strength * (double)effect.m_19557_()));
            int newDuration = Mth.m_14107_((double)(newRatio * strength * (double)effect.m_19557_()));
            int duration = newDuration - prevDuration;
            if (duration <= 0) continue;
            MobEffectInstance effectInstance = new MobEffectInstance(effect.m_19544_(), duration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_());
            Potion curEffect = new Potion(new MobEffectInstance[]{effectInstance});
            this.addPotionEffectDuration(entity, curEffect);
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        PBNBTHelper.writeNBTPotions("potions", this.effects, compound);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.effects = PBNBTHelper.readNBTPotions("potions", compound);
    }
}

