/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class PBEffectEntitiesTeleport
extends PBEffectEntityBased {
    private double teleportRange;
    private int teleports;

    public PBEffectEntitiesTeleport() {
    }

    public PBEffectEntitiesTeleport(int maxTicksAlive, double range, double teleportRange, int teleports) {
        super(maxTicksAlive, range);
        this.teleportRange = teleportRange;
        this.teleports = teleports;
    }

    @Override
    public void affectEntity(Level world, PandorasBoxEntity box, RandomSource random, LivingEntity entity, double newRatio, double prevRatio, double strength) {
        if (world instanceof ServerLevel) {
            Random entityRandom = new Random(entity.m_19879_());
            for (int i = 0; i < this.teleports; ++i) {
                double expectedTeleport = entityRandom.nextDouble();
                if (!(newRatio >= expectedTeleport) || !(prevRatio < expectedTeleport)) continue;
                double newX = entity.m_20185_() + (random.m_188500_() - random.m_188500_()) * this.teleportRange;
                double newZ = entity.m_20189_() + (random.m_188500_() - random.m_188500_()) * this.teleportRange;
                double newY = (double)world.m_5452_(Heightmap.Types.MOTION_BLOCKING, BlockPos.m_274561_((double)newX, (double)0.0, (double)newZ)).m_123342_() + 0.2;
                float newYaw = random.m_188501_() * 360.0f;
                entity.m_6021_(newX, newY, newZ);
                if (!(entity instanceof ServerPlayer)) continue;
                ((ServerPlayer)entity).f_8906_.m_9774_(newX, newY, newZ, newYaw, entity.m_146909_());
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128347_("teleportRange", this.teleportRange);
        compound.m_128405_("teleports", this.teleports);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.teleportRange = compound.m_128459_("teleportRange");
        this.teleports = compound.m_128451_("teleports");
    }
}

