/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PBEffectEntitiesThrowItems
extends PBEffectEntityBased {
    public double chancePerItem;
    public double itemDeletionChance;
    public ItemStack[] smuggledInItems;

    public PBEffectEntitiesThrowItems() {
    }

    public PBEffectEntitiesThrowItems(int maxTicksAlive, double range, double chancePerItem, double itemDeletionChance, ItemStack[] smuggledInItems) {
        super(maxTicksAlive, range);
        this.chancePerItem = chancePerItem;
        this.itemDeletionChance = itemDeletionChance;
        this.smuggledInItems = smuggledInItems;
    }

    @Override
    public void affectEntity(Level world, PandorasBoxEntity box, RandomSource random, LivingEntity entity, double newRatio, double prevRatio, double strength) {
        if (world instanceof ServerLevel && entity instanceof Player) {
            Player player = (Player)entity;
            Random itemRandom = new Random(entity.m_19879_());
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack;
                double expectedThrow = itemRandom.nextDouble();
                if (!(newRatio >= expectedThrow) || !(prevRatio < expectedThrow) || (stack = player.m_150109_().m_8020_(i)) == null || !(random.m_188500_() < this.chancePerItem)) continue;
                if (random.m_188500_() >= this.itemDeletionChance) {
                    player.m_36176_(stack, false);
                }
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
            for (ItemStack smuggledInItem : this.smuggledInItems) {
                double expectedThrow = itemRandom.nextDouble();
                if (!(newRatio >= expectedThrow) || !(prevRatio < expectedThrow)) continue;
                player.m_36176_(smuggledInItem, false);
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128347_("chancePerItem", this.chancePerItem);
        compound.m_128347_("itemDeletionChance", this.itemDeletionChance);
        PBNBTHelper.writeNBTStacks("smuggledInItems", this.smuggledInItems, compound);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.chancePerItem = compound.m_128459_("chancePerItem");
        this.itemDeletionChance = compound.m_128459_("itemDeletionChance");
        this.smuggledInItems = PBNBTHelper.readNBTStacks("smuggledInItems", compound);
    }
}

