/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class PBEffectEntityBased
extends PBEffectNormal {
    public double range;

    public PBEffectEntityBased() {
    }

    public PBEffectEntityBased(int maxTicksAlive, double range) {
        super(maxTicksAlive);
        this.range = range;
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
        AABB bb = new AABB(effectCenter.f_82479_ - this.range, effectCenter.f_82480_ - this.range, effectCenter.f_82481_ - this.range, effectCenter.f_82479_ + this.range, effectCenter.f_82480_ + this.range, effectCenter.f_82481_ + this.range);
        List entities = world.m_45976_(LivingEntity.class, bb);
        for (LivingEntity entityLivingBase : entities) {
            double dist = entityLivingBase.m_20270_((Entity)entity);
            double strength = (this.range - dist) / this.range;
            if (!(strength > 0.0)) continue;
            this.affectEntity(world, entity, random, entityLivingBase, newRatio, prevRatio, strength);
        }
    }

    public abstract void affectEntity(Level var1, PandorasBoxEntity var2, RandomSource var3, LivingEntity var4, double var5, double var7, double var9);

    @Override
    public void writeToNBT(CompoundTag compound) {
        compound.m_128347_("range", this.range);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        this.range = compound.m_128459_("range");
    }
}

