/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class PBEffectGenConvertToNether
extends PBEffectGenerate {
    private String biome;
    private int timesFeatureAMade = 0;
    private int timesFeatureBMade = 0;

    public PBEffectGenConvertToNether() {
    }

    public PBEffectGenConvertToNether(int time, double range, int unifiedSeed, String biome) {
        super(time, range, 2, unifiedSeed);
        this.biome = biome;
    }

    @Override
    public void generateOnBlock(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos, double range) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            switch (this.biome) {
                case "wastes": {
                    this.createWastes(serverLevel, entity, effectCenter, random, pass, pos);
                    break;
                }
                case "soul_sand_valley": {
                    this.createSoul(serverLevel, entity, effectCenter, random, pass, pos);
                    break;
                }
                case "crimson": {
                    this.createCrimson(serverLevel, entity, effectCenter, random, pass, pos);
                    break;
                }
                case "warped": {
                    this.createWarped(serverLevel, entity, effectCenter, random, pass, pos);
                    break;
                }
                case "deltas": {
                    this.createDeltas(serverLevel, entity, effectCenter, random, pass, pos);
                }
            }
        }
    }

    public static BiomeResolver makeResolver(Holder<Biome> biomeHolder) {
        return (x, y, z, climateSampler) -> biomeHolder;
    }

    public void createWastes(ServerLevel world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos) {
        Registry configuredFeatureRegistry;
        boolean success;
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50191_, Blocks.f_50180_, Blocks.f_50181_, Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50073_, Blocks.f_50072_);
        misc.addAll(Blocks.f_50440_, Blocks.f_152544_, Blocks.f_50493_, Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_152550_, Blocks.f_50062_, Blocks.f_50394_, Blocks.f_50259_, Blocks.f_50195_);
        blocks.addAll(new Collection[]{PandorasBox.flowers, PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50652_, Blocks.f_50126_, Blocks.f_49990_, Blocks.f_50080_)) {
                Optional integer = blockState.m_61145_((Property)LiquidBlock.f_54688_);
                Object blockState2 = Blocks.f_49991_.m_49966_();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, (BlockState)blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((Level)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50129_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50450_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49997_, Blocks.f_152469_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50331_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49995_, Blocks.f_152467_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_49998_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49992_, Blocks.f_49993_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50135_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50134_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50122_, Blocks.f_152496_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50730_.m_49966_());
            } else if (world.m_8055_(pos).m_60795_()) {
                if (random.m_188503_(25) == 0) {
                    if (world.f_46441_.m_188501_() < 0.99f) {
                        if (world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13085_)) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50084_.m_49966_());
                        } else if (!world.m_8055_(pos.m_7495_()).m_60795_()) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50083_.m_49966_());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50141_.m_49966_());
                    }
                } else if (!world.m_8055_(pos.m_7494_()).m_60795_() && (double)random.m_188501_() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "piglin", 0.0011111111f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "zombified_piglin", 0.0044444446f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "magma_cube", 0.0044444446f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "hoglin", 0.0025f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((Level)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((Level)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
        if (random.m_188500_() < Math.pow(0.4, Math.floor((double)this.timesFeatureAMade / 4.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && blockBelowState.m_60796_((BlockGetter)world, posBelow) && (success = Objects.requireNonNull((ConfiguredFeature)(configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_)).m_6246_(VegetationFeatures.f_195176_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos))) {
                ++this.timesFeatureAMade;
            }
        }
        if (random.m_188500_() < Math.pow(0.3, Math.floor((double)this.timesFeatureBMade / 4.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && blockBelowState.m_60796_((BlockGetter)world, posBelow) && (success = Objects.requireNonNull((ConfiguredFeature)(configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_)).m_6246_(VegetationFeatures.f_195177_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos))) {
                ++this.timesFeatureBMade;
            }
        }
        this.changeBiome((ResourceKey<Biome>)Biomes.f_48209_, pass, effectCenter, world);
    }

    public void createSoul(ServerLevel world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50191_, Blocks.f_50180_, Blocks.f_50181_, Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50073_, Blocks.f_50072_);
        misc.addAll(Blocks.f_50440_, Blocks.f_152544_, Blocks.f_50493_, Blocks.f_50259_, Blocks.f_50195_);
        blocks.addAll(new Collection[]{PandorasBox.flowers, PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50652_, Blocks.f_50126_, Blocks.f_49990_, Blocks.f_50080_)) {
                Optional integer = blockState.m_61145_((Property)LiquidBlock.f_54688_);
                BlockState blockState2 = Blocks.f_49991_.m_49966_();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((Level)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49992_, Blocks.f_50129_, Blocks.f_49993_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50135_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49997_, Blocks.f_152469_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50331_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49995_, Blocks.f_152467_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_49998_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50136_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_152550_, Blocks.f_50062_, Blocks.f_50394_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50134_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50122_, Blocks.f_152496_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50730_.m_49966_());
            } else if (world.m_8055_(pos).m_60795_()) {
                boolean bl;
                boolean bl2 = !PBEffectGenConvertToNether.isBlockAnyOf(world.m_8055_(pos.m_7495_()).m_60734_(), Blocks.f_50453_) ? random.m_188503_(40) == 0 : (bl = random.m_188503_(20) == 0);
                if (random.m_188503_(25) == 0) {
                    if (world.f_46441_.m_188501_() < 0.99f) {
                        if (world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13085_)) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50084_.m_49966_());
                        } else if (!world.m_8055_(pos.m_7495_()).m_60795_()) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50083_.m_49966_());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50141_.m_49966_());
                    }
                } else if (!world.m_8055_(pos.m_7494_()).m_60795_() && (double)random.m_188501_() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                } else if (!world.m_8055_(pos.m_7495_()).m_60795_() && !PBEffectGenConvertToNether.isBlockAnyOf(world.m_8055_(pos.m_7495_()).m_60734_(), Blocks.f_50141_) && bl) {
                    PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50453_.m_49966_());
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "skeleton", 0.0044444446f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "zombified_piglin", 0.0044444446f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((Level)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((Level)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
        this.changeBiome((ResourceKey<Biome>)Biomes.f_48199_, pass, effectCenter, world);
    }

    private void createGlowstoneBlobs(ServerLevel world, BlockPos pos, RandomSource random) {
        Registry configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_);
        Objects.requireNonNull((ConfiguredFeature)configuredFeatureRegistry.m_6246_(NetherFeatures.f_195034_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos);
    }

    public void createCrimson(ServerLevel world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos) {
        boolean success;
        Registry configuredFeatureRegistry;
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> flowers = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50191_, Blocks.f_50180_, Blocks.f_50181_, Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50073_, Blocks.f_50072_);
        misc.addAll(Blocks.f_50440_, Blocks.f_152544_, Blocks.f_50493_, Blocks.f_50069_, Blocks.f_50334_, Blocks.f_152550_, Blocks.f_50228_, Blocks.f_50259_, Blocks.f_50195_, Blocks.f_49992_, Blocks.f_50062_, Blocks.f_49993_, Blocks.f_50394_);
        blocks.addAll(new Collection[]{PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        flowers.addAll(PandorasBox.flowers);
        blocks.removeAll(Blocks.f_50695_, Blocks.f_50696_, Blocks.f_50686_, Blocks.f_50687_);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50652_, Blocks.f_50126_, Blocks.f_49990_, Blocks.f_50080_)) {
                Optional integer = blockState.m_61145_((Property)LiquidBlock.f_54688_);
                Object blockState2 = Blocks.f_49991_.m_49966_();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, (BlockState)blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((Level)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50129_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50450_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49997_, Blocks.f_152469_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50331_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49995_, Blocks.f_152467_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_49998_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                if (random.m_188500_() < 0.2 || !world.m_8055_(pos.m_7494_()).m_60795_()) {
                    PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50134_.m_49966_());
                } else {
                    PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50699_.m_49966_());
                }
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, flowers)) {
                if (random.m_188500_() < 0.5) {
                    PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50654_.m_49966_());
                } else {
                    PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50700_.m_49966_());
                }
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50122_, Blocks.f_152496_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50730_.m_49966_());
            } else if (world.m_8055_(pos).m_60795_()) {
                if (random.m_188503_(25) == 0) {
                    if (world.f_46441_.m_188501_() < 0.99f) {
                        if (world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13085_)) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50084_.m_49966_());
                        } else if (!world.m_8055_(pos.m_7495_()).m_60795_()) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50083_.m_49966_());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50141_.m_49966_());
                    }
                } else if (!world.m_8055_(pos.m_7494_()).m_60795_() && (double)random.m_188501_() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "piglin", 0.01f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "zombified_piglin", 0.0016f, pos), PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "hoglin", 0.01f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((Level)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((Level)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
        if (random.m_188500_() < Math.pow(0.4, Math.floor((double)this.timesFeatureAMade / 8.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && !blockBelowState.m_60713_(Blocks.f_50451_) && blockBelowState.m_60796_((BlockGetter)world, posBelow)) {
                configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_);
                PBEffectGenConvertToNether.setBlockSafe((Level)world, posBelow, Blocks.f_50699_.m_49966_());
                success = Objects.requireNonNull((ConfiguredFeature)configuredFeatureRegistry.m_6246_(TreeFeatures.f_195118_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos);
                if (success) {
                    ++this.timesFeatureAMade;
                }
            }
        }
        if (random.m_188500_() < Math.pow(0.6, Math.floor((double)this.timesFeatureBMade / 10.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && !blockBelowState.m_60713_(Blocks.f_50451_) && blockBelowState.m_60796_((BlockGetter)world, posBelow)) {
                configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_);
                PBEffectGenConvertToNether.setBlockSafe((Level)world, posBelow, Blocks.f_50699_.m_49966_());
                success = Objects.requireNonNull((ConfiguredFeature)configuredFeatureRegistry.m_6246_(NetherFeatures.f_195036_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos);
                if (success) {
                    ++this.timesFeatureBMade;
                }
            }
        }
        this.changeBiome((ResourceKey<Biome>)Biomes.f_48200_, pass, effectCenter, world);
    }

    public void createWarped(ServerLevel world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos) {
        boolean success;
        Registry configuredFeatureRegistry;
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState;
        block14: {
            block12: {
                block22: {
                    block23: {
                        block24: {
                            block21: {
                                Block block;
                                block20: {
                                    ArrayListExtensions<Block> flowers;
                                    block19: {
                                        ArrayListExtensions<Block> misc;
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        ArrayListExtensions<Block> blocks;
                                                        block13: {
                                                            blockState = world.m_8055_(pos);
                                                            block = blockState.m_60734_();
                                                            blocks = new ArrayListExtensions<Block>();
                                                            misc = new ArrayListExtensions<Block>();
                                                            flowers = new ArrayListExtensions<Block>();
                                                            blocks.addAll(Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50191_, Blocks.f_50180_, Blocks.f_50181_, Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50073_, Blocks.f_50072_);
                                                            misc.addAll(Blocks.f_50440_, Blocks.f_152544_, Blocks.f_50493_, Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50122_, Blocks.f_152550_, Blocks.f_50259_, Blocks.f_50195_, Blocks.f_49992_, Blocks.f_50062_, Blocks.f_49993_, Blocks.f_50394_);
                                                            blocks.addAll(new Collection[]{PandorasBox.logs, PandorasBox.leaves});
                                                            misc.addAll(PandorasBox.terracotta);
                                                            flowers.addAll(PandorasBox.flowers);
                                                            blocks.removeAll(Blocks.f_50695_, Blocks.f_50696_, Blocks.f_50686_, Blocks.f_50687_);
                                                            if (pass != 0) break block12;
                                                            if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50652_, Blocks.f_50126_, Blocks.f_49990_, Blocks.f_50080_)) break block13;
                                                            Optional integer = blockState.m_61145_((Property)LiquidBlock.f_54688_);
                                                            BlockState blockState2 = Blocks.f_49991_.m_49966_();
                                                            if (integer.isPresent()) {
                                                                blockState2 = (BlockState)blockState2.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)((Integer)integer.get()));
                                                            }
                                                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, blockState2);
                                                            break block14;
                                                        }
                                                        if (!PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) break block15;
                                                        PBEffectGenConvertToNether.setBlockToAirSafe((Level)world, pos);
                                                        break block14;
                                                    }
                                                    if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50129_)) break block16;
                                                    PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50450_.m_49966_());
                                                    break block14;
                                                }
                                                if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49997_, Blocks.f_152469_)) break block17;
                                                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50331_.m_49966_());
                                                break block14;
                                            }
                                            if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49995_, Blocks.f_152467_)) break block18;
                                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_49998_.m_49966_());
                                            break block14;
                                        }
                                        if (!PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) break block19;
                                        if (random.m_188500_() < 0.2 || !world.m_8055_(pos.m_7494_()).m_60795_()) {
                                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50134_.m_49966_());
                                        } else {
                                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50690_.m_49966_());
                                        }
                                        break block14;
                                    }
                                    if (!PBEffectGenConvertToNether.isBlockAnyOf(block, flowers)) break block20;
                                    if (random.m_188500_() < 0.5) {
                                        PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50693_.m_49966_());
                                    } else {
                                        PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50691_.m_49966_());
                                    }
                                    break block14;
                                }
                                if (!PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50122_, Blocks.f_152496_)) break block21;
                                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50730_.m_49966_());
                                break block14;
                            }
                            if (!world.m_8055_(pos).m_60795_()) break block14;
                            if (random.m_188503_(25) != 0) break block22;
                            if (!(world.f_46441_.m_188501_() < 0.99f)) break block23;
                            if (!world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13085_)) break block24;
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50084_.m_49966_());
                            break block14;
                        }
                        if (world.m_8055_(pos.m_7495_()).m_60795_()) break block14;
                        PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50083_.m_49966_());
                        break block14;
                    }
                    PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50141_.m_49966_());
                    break block14;
                }
                if (world.m_8055_(pos.m_7494_()).m_60795_() || !((double)random.m_188501_() < 0.02)) break block14;
                this.createGlowstoneBlobs(world, pos, random);
                break block14;
            }
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "enderman", 0.0044444446f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((Level)world, blockState, pos, entity1);
            }
        }
        if (random.m_188500_() < Math.pow(0.4, Math.floor((double)this.timesFeatureAMade / 8.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && !blockBelowState.m_60713_(Blocks.f_50451_) && blockBelowState.m_60796_((BlockGetter)world, posBelow)) {
                configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_);
                PBEffectGenConvertToNether.setBlockSafe((Level)world, posBelow, Blocks.f_50690_.m_49966_());
                success = Objects.requireNonNull((ConfiguredFeature)configuredFeatureRegistry.m_6246_(TreeFeatures.f_195120_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos);
                if (success) {
                    ++this.timesFeatureAMade;
                }
            }
        }
        if (random.m_188500_() < Math.pow(0.6, Math.floor((double)this.timesFeatureBMade / 10.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && !blockBelowState.m_60713_(Blocks.f_50692_) && blockBelowState.m_60796_((BlockGetter)world, posBelow)) {
                configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_);
                PBEffectGenConvertToNether.setBlockSafe((Level)world, posBelow, Blocks.f_50690_.m_49966_());
                success = Objects.requireNonNull((ConfiguredFeature)configuredFeatureRegistry.m_6246_(NetherFeatures.f_195039_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos);
                if (success) {
                    ++this.timesFeatureBMade;
                }
            }
        }
        this.changeBiome((ResourceKey<Biome>)Biomes.f_48201_, pass, effectCenter, world);
    }

    public void createDeltas(ServerLevel world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos) {
        Registry configuredFeatureRegistry;
        boolean success;
        BlockState blockBelowState;
        BlockPos posBelow;
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        ArrayListExtensions<Block> blocks = new ArrayListExtensions<Block>();
        ArrayListExtensions<Block> misc = new ArrayListExtensions<Block>();
        blocks.addAll(Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50191_, Blocks.f_50180_, Blocks.f_50181_, Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50073_, Blocks.f_50072_);
        misc.addAll(Blocks.f_50440_, Blocks.f_152544_, Blocks.f_50493_, Blocks.f_50259_, Blocks.f_50195_);
        blocks.addAll(new Collection[]{PandorasBox.flowers, PandorasBox.logs, PandorasBox.leaves});
        misc.addAll(PandorasBox.terracotta);
        if (pass == 0) {
            if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50652_, Blocks.f_50126_, Blocks.f_49990_, Blocks.f_50080_)) {
                Optional integer = blockState.m_61145_((Property)LiquidBlock.f_54688_);
                BlockState blockState2 = Blocks.f_49991_.m_49966_();
                if (integer.isPresent()) {
                    blockState2 = (BlockState)blockState2.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)((Integer)integer.get()));
                }
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, blockState2);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, blocks)) {
                PBEffectGenConvertToNether.setBlockToAirSafe((Level)world, pos);
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50129_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50450_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49997_, Blocks.f_152469_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50331_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_49995_, Blocks.f_152467_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_49998_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, misc)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50137_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_152550_, Blocks.f_50062_, Blocks.f_50394_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50134_.m_49966_());
            } else if (PBEffectGenConvertToNether.isBlockAnyOf(block, Blocks.f_50122_, Blocks.f_152496_, Blocks.f_49992_, Blocks.f_49993_)) {
                PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50730_.m_49966_());
            } else if (world.m_8055_(pos).m_60795_()) {
                if (random.m_188503_(25) == 0) {
                    if (world.f_46441_.m_188501_() < 0.99f) {
                        if (world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13085_)) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50084_.m_49966_());
                        } else if (!world.m_8055_(pos.m_7495_()).m_60795_()) {
                            PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50083_.m_49966_());
                        }
                    } else {
                        PBEffectGenConvertToNether.setBlockSafe((Level)world, pos, Blocks.f_50141_.m_49966_());
                    }
                } else if (!world.m_8055_(pos.m_7494_()).m_60795_() && (double)random.m_188501_() < 0.02) {
                    this.createGlowstoneBlobs(world, pos, random);
                }
            }
        } else {
            ArrayListExtensions<Entity> entities = new ArrayListExtensions<Entity>();
            entities.addAll(PBEffectGenConvertToNether.lazilySpawnEntity((Level)world, entity, random, "magma_cube", 0.0044444446f, pos));
            for (Entity entity1 : entities) {
                PBEffectGenConvertToNether.canSpawnEntity((Level)world, blockState, pos, entity1);
            }
            if (this.canSpawnFlyingEntity((Level)world, blockState, pos)) {
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "ghast", 8.0E-6f, pos);
                PBEffectGenConvertToNether.lazilySpawnFlyingEntity((Level)world, entity, random, "blaze", 8.0E-6f, pos);
            }
        }
        if (random.m_188500_() < Math.pow(0.8, Math.floor((double)this.timesFeatureAMade / 4.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && blockBelowState.m_60796_((BlockGetter)world, posBelow) && (success = Objects.requireNonNull((ConfiguredFeature)(configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_)).m_6246_(NetherFeatures.f_195030_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos))) {
                ++this.timesFeatureAMade;
            }
        }
        if (random.m_188500_() < Math.pow(0.3, Math.floor((double)this.timesFeatureBMade / 4.0))) {
            posBelow = pos.m_7495_();
            blockBelowState = world.m_8055_(posBelow);
            if (blockState.m_60795_() && blockBelowState.m_60796_((BlockGetter)world, posBelow) && (success = Objects.requireNonNull((ConfiguredFeature)(configuredFeatureRegistry = world.m_9598_().m_175515_(Registries.f_256911_)).m_6246_(NetherFeatures.f_195031_)).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, pos))) {
                ++this.timesFeatureBMade;
            }
        }
        this.changeBiome((ResourceKey<Biome>)Biomes.f_48175_, pass, effectCenter, world);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.biome = compound.m_128461_("biome");
        this.timesFeatureAMade = compound.m_128451_("featureACount");
        this.timesFeatureBMade = compound.m_128451_("featureBCount");
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        if (this.biome != null) {
            compound.m_128359_("biome", this.biome);
        }
        compound.m_128405_("featureACount", this.timesFeatureAMade);
        compound.m_128405_("featureBCount", this.timesFeatureBMade);
    }
}

