/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.weighted.WeightedBlock;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PBEffectGenCreativeTowers
extends PBEffectGenerateByStructure {
    public PBEffectGenCreativeTowers() {
    }

    public PBEffectGenCreativeTowers(int maxTicksAlive) {
        super(maxTicksAlive);
    }

    public void createRandomStructures(RandomSource random, int number, double range, Collection<WeightedBlock> blocks) {
        this.structures = new PBEffectGenerateByStructure.Structure[number];
        for (int i = 0; i < number; ++i) {
            this.structures[i] = this.createStructure();
            PBEffectGenCreativeTowers.applyRandomProperties(this.structures[i], range, random);
            ((StructureCreativeTower)this.structures[i]).blocks = PandorasBoxHelper.getRandomBlockList(random, blocks);
        }
    }

    @Override
    public void generateStructure(Level world, PandorasBoxEntity entity, RandomSource random, PBEffectGenerateByStructure.Structure structure, BlockPos pos, float newRatio, float prevRatio) {
        if (world instanceof ServerLevel) {
            int prevY;
            StructureCreativeTower structureCreativeTower = (StructureCreativeTower)structure;
            int towerHeight = world.m_151558_();
            int newY = Mth.m_14143_((float)((float)towerHeight * newRatio));
            for (int towerY = prevY = Mth.m_14143_((float)((float)towerHeight * prevRatio)); towerY < newY; ++towerY) {
                Block block = structureCreativeTower.blocks[random.m_188503_(structureCreativeTower.blocks.length)];
                PBEffectGenCreativeTowers.setBlockVarying(world, new BlockPos(pos.m_123341_() + structure.x, towerY, pos.m_123343_() + structure.z), block, structure.unifiedSeed);
            }
        }
    }

    @Override
    public StructureCreativeTower createStructure() {
        return new StructureCreativeTower();
    }

    public static class StructureCreativeTower
    extends PBEffectGenerateByStructure.Structure {
        public Block[] blocks;

        @Override
        public void writeToNBT(CompoundTag compound) {
            super.writeToNBT(compound);
            PBNBTHelper.writeNBTBlocks("blocks", this.blocks, compound);
        }

        @Override
        public void readFromNBT(CompoundTag compound) {
            super.readFromNBT(compound);
            this.blocks = PBNBTHelper.readNBTBlocks("blocks", compound);
        }
    }
}

